import Vue from 'vue'
import VueI18n from 'vue-i18n'
import elementEnLocale from 'element-ui/lib/locale/lang/en' // element-ui lang
import elementZhLocale from 'element-ui/lib/locale/lang/zh-CN'// element-ui lang
import elementZhTWLocale from 'element-ui/lib/locale/lang/zh-TW'// element-ui lang
import enLocale from '@/locale/lang/en'
import zhLocale from '@/locale/lang/zh-CN'
import zhTWLocale from '@/locale/lang/zh-TW'

Vue.use(VueI18n)

const messages = {
  "en-US": {
    ...enLocale,
    ...elementEnLocale
  },
  "zh-CN": {
    ...zhLocale,
    ...elementZhLocale
  },
  "zh-TW": {
    ...zhTWLocale,
    ...elementZhTWLocale
  }
}

const i18n = new VueI18n({
  // set locale
  // options: en | zh 
  locale: localStorage.getItem("lang") || 'zh-CN',
  // set locale messages
  messages
})

export default i18n