import utils from "@/utils.js";
var service = {
    // 对联动规则进行处理
    linkageHandler: (_me, exp) => {
        if (!_me || !_me._isVue) {
            throw "传入的对象为空或者不是VueComponent类型.";
        }
        if (!exp || (exp.constructor !== Object && exp.constructor !== Array)) {
            throw `传入的对象${exp}为空，或者既不是Object类型也不是Array类型.`;
        }
        let linkageExp = exp;
        if (exp.constructor === Object) {
            linkageExp = [exp];
        }
        const pInst = utils.getOnlineFormInstance(_me);
        if (!pInst) {
            throw "没有获取到控件所在的表单";
        }
        // 当前控件的联动轨迹
        _me.traces = {};

        //修改子表或孙表行内联动权限
        let operationEleByPermission = function(n, permission){
            let idxObj = utils.getSubScopeElAndIndex(_me.$el);
            let tpaths = n.target.split('.');
            let fPoint = n.boType+'_'+tpaths[tpaths.length-2]+'_'+tpaths[tpaths.length-1]+'_'+idxObj.index;
            let basePath = 'permission.subFields';
            //孙表时，获取孙表所属子表序号
            if(n.boType=='sun'){
                const subIdxObj = utils.getSubScopeElAndIndex(idxObj.subScopeEl.parentElement);
                fPoint = n.boType+'_'+tpaths[tpaths.length-2]+'_'+tpaths[tpaths.length-1] +'_'+subIdxObj.index+'_'+idxObj.index;
            }
            if(!pInst.permission['subFields']){
                utils.setValueByPath(pInst, basePath, {});
            }
            utils.setValueByPath(pInst, basePath+'.'+fPoint, permission);
        };

        linkageExp.forEach(m => {
            m.effect.forEach(n => {
                // 联动会影响字段的显示、隐藏、必填等权限，以及字段的校验规则。
                // 这里先将这两部分信息存放起来作为恢复的轨迹数据
                _me.traces[n.target] = utils.getValueByPath(pInst, n.target);

            });
        });

        _me.$watch(
            "inputVal",
            function (newVal, oldVal) {
                if (newVal !== oldVal) {
                    // 两个对象是否相等
                    if (newVal && newVal.constructor == Object && utils.objectEquals(newVal, oldVal)) {
                        return;
                    }
                    // 两个数组是否相等
                    if (newVal && newVal.constructor == Array && utils.arrayEquals(newVal, oldVal)) {
                        return;
                    }
                    // 在联动触发之前，先还原一次

                    linkageExp.forEach(m => {
                        m.effect.forEach(n => {
                            if (n.target) {
                                let boType = n.boType;
                                let traceValue = _me.traces[n.target];
                                if(boType && (boType=='sub' || boType=='sun')){
                                    operationEleByPermission(n, traceValue);
                                }else{
                                    utils.setValueByPath(pInst, n.target, traceValue);
                                }
                            }
                            if(n.ref && n.ref.indexOf("sub_")!=-1){
                                let arr = n.ref.split(".");
                                //子表
                                if(arr.length==4){
                                    if (n.ref && document.querySelector('[model-name="' + n.ref + '"]')) {
                                        let idxObj = utils.getSubScopeElAndIndex(_me.$el);//获取子表对象（含下标)
                                        let subModeNameArray = document.querySelectorAll('[model-name="' + n.ref + '"]');
                                        subModeNameArray[idxObj.index].__vue__._data.newValidate = null;
                                    }
                                }
                            }else{
                                //主表
                                if (n.ref && document.querySelector('[model-name="' + n.ref + '"]')) {
                                    document.querySelector('[model-name="' + n.ref + '"]').__vue__._data.newValidate = null;
                                }
                            }
                        });
                    });

                    linkageExp.forEach(m => {
                        // 是否匹配联动要求的值
                        let match = false;
                        if (newVal) {
                            if (newVal.constructor === String) {
                                match = newVal === m.value;
                            }
                            else if (newVal.constructor === Array) {
                                match = newVal.some(v => v === m.value);
                            }
                        }
                        m.effect.forEach(n => {
                            if (match) {
                                switch (n.type) {
                                    // 直接赋值
                                    case "=":
                                        //如果表单是只读的情况下,控件的必填与可编辑替换成只读
                                        let v=n.value;
                                        if(pInst.isLook && ( n.value==='b' || n.value === 'w')){
                                            v='r';
                                        }
                                        let boType = n.boType;
                                        if(boType && (boType=='sub' || boType=='sun')){
                                            operationEleByPermission(n, v);
                                        }else{
                                            utils.setValueByPath(pInst, n.target, v);
                                        }
                                        break;
                                    // 追加验证规则
                                    case "+":
                                        if (!n.value ||
                                            (n.value.constructor !== Object &&
                                                n.value.constructor !== String)) {
                                            throw `联动时要追加的验证规则${n.value}既不是String类型也不是Object类型`;
                                        }
                                        if (n.target) {
                                            // 获取旧的校验规则
                                            const oldValid = utils.getValueByPath(pInst, n.target);
                                            // 将旧规则与新规则进行融合
                                            const newValid = utils.mergeValidate(oldValid, n.value);
                                            // 更新融合后的规则
                                            utils.setValueByPath(pInst, n.target, newValid);
                                        }
                                        if (n.ref) {
                                            setTimeout(() => {
                                                if (document.querySelector('[model-name="' + n.ref + '"]')) {
                                                    if(n.ref && n.ref.indexOf("sub_")!=-1){
                                                        let arr = n.ref.split(".");
                                                        //子表
                                                        if(arr.length==4){
                                                            let idxObj = utils.getSubScopeElAndIndex(_me.$el);
                                                            let subModeNameArray = document.querySelectorAll('[model-name="' + n.ref + '"]');
                                                            let targetVnode = subModeNameArray[idxObj.index].__vue__;
                                                            let oldValid = targetVnode.validate;
                                                            // 将旧规则与新规则进行融合
                                                            const newValid = utils.mergeValidate(oldValid, n.value);
                                                            targetVnode._data.newValidate = newValid;
                                                        }
                                                    }else{
                                                        //主表
                                                        let targetVnode = document.querySelector('[model-name="' + n.ref + '"]').__vue__;
                                                        let oldValid = targetVnode.validate;
                                                        // 将旧规则与新规则进行融合
                                                        const newValid = utils.mergeValidate(oldValid, n.value);
                                                        targetVnode._data.newValidate = newValid;
                                                    }
                                                }
                                            }, 100);
                                        }
                                        break;
                                    // 减少验证规则
                                    case "-":
                                        if (
                                            !n.value ||
                                            (n.value.constructor !== Object &&
                                                n.value.constructor !== String)
                                        ) {
                                            throw `联动时要减少的验证规则${n.value}既不是String类型也不是Object类型`;
                                        }
                                        if (n.target) {
                                            // 获取旧的规则
                                            const oldV = utils.getValueByPath(pInst, n.target);
                                            // 从旧的规则移除指定规则
                                            const newValidate = utils.reduceValidate(oldV, n.value);
                                            // 更新规则
                                            utils.setValueByPath(pInst, n.target, newValidate);
                                        }

                                        if (n.ref) {
                                            const oldValid = pInst.$refs[n.ref].validate;
                                            // 将旧规则与新规则进行融合
                                            const newValid = utils.reduceValidate(oldValid, n.value);
                                            pInst.$refs[n.ref].newValidate = newValid;
                                        }

                                        break;
                                }
                            }
                        });
                    });
                }
            },
            { immediate: true }
        );
    },
    // 通用查询
    commonQuery: (_me, exp) => {
        debugger;
    }
}

export default service;
