import Vue from "vue";
import Router from "vue-router";
import Installation from "@/demo/Installation.vue";
import Table from "@/demo/Table.vue";
import Input from "@/demo/Input.vue";
import DemensionSelector from "@/components/common/DemensionSelector.vue";
import Tree from "@/demo/Tree.vue";
import QueryStrategy from "@/demo/QueryStrategy.vue";
import SidebarDialog from "@/demo/SidebarDialog.vue";
import I18n from "@/demo/I18n.vue";
import Selector from "@/demo/Selector.vue";
const tabs = () => import("@/demo/tabs.vue");
const Dialog = () => import("@/demo/Dialog.vue");

Vue.use(Router);

var router = new Router({
    mode: "history", // hash  history
    base: process.env.BASE_URL,
    routes: [{
        path: "/",
        redirect: {
            name: "basic"
        }
    },
    {
        path: "/installation",
        name: "installation",
        component: Installation
    },
    {
        path: "/input",
        name: "input",
        component: Input
    },
    {
        path: "/basic",
        name: "basic",
        component: () => import("@/demo/Form.vue")
    },
    {
        path: "/demension",
        name: "demension",
        component: DemensionSelector
    },
    {
        path: "/table",
        name: "table",
        component: Table
    },
    {
        path: "/tree",
        name: "tree",
        component: Tree
    },
    {
        path: "/queryStrategy",
        name: "queryStrategy",
        component: QueryStrategy
    },
    {
        path: "/sidebarDialog",
        name: "sidebarDialog",
        component: SidebarDialog
    },
    {
        path: "/i18n",
        name: "i18n",
        component: I18n
    },
    {
        path: "/selector",
        name: "selector",
        component: Selector
    },
    {
        path: "/tabs",
        name: "tabs",
        component: tabs
    }, {
        path: "/dialog",
        name: "dialog",
        component: Dialog
    }, {
        path: "/validation",
        name: "validation",
        component: () => import("@/demo/Validation.vue")
    }, {
        path: "/math",
        name: "math",
        component: () => import("@/demo/Math.vue")
    }, {
        path: "/linkage",
        name: "linkage",
        component: () => import("@/demo/Linkage.vue")
    }, {
        path: "/tools",
        name: "tools",
        component: () => import("@/demo/Tools.vue")
    },
    {
        path: "/attachment",
        name: "attachment",
        component: () => import("@/demo/Attachment.vue")
    }
    ]
});

export default router;
