import Vue from "vue";
import router from "./router";
import App from "./App.vue";
import ElementUI from "element-ui";
import Element from "element-ui";
import HotentUi from "@/components/index";
import "babel-polyfill";
import VueShowdown from "vue-showdown";
import VueHighlightJS from "vue-highlightjs";
import VueClipboard from "vue-clipboard2";
import VueResource from "vue-resource";
import "@/assets/css/element-variables.scss";
import i18n from "./vue-i18n.js";

Vue.config.productionTip = false;
Vue.use(ElementUI, {
  i18n: (key, value) => i18n.t(key, value)
});
Vue.use(HotentUi, {
  i18n: (key, value) => i18n.t(key, value)
});
Vue.use(Element, { size: "small" });
Vue.use(VueShowdown, {
  options: {
    tables: true
  }
});
Vue.use(VueResource);
Vue.use(VueHighlightJS);
Vue.use(VueClipboard);
var app = new Vue({
  router,
  i18n,
  render: h => h(App)
}).$mount("#app");

let validateLocal = localStorage.getItem("lang");
let currentLocal = validateLocal || "zh-CN";
app && app.$validator && app.$validator.localize(currentLocal);