## 表单中的组件

1. [单行文本](#1)
2. [单选按钮](#2)
3. [复选框](#3)
4. [日期时间](#4)
5. [下拉框](#5)
6. [附件上传](#6)
7. [选择器](#7)
8. [时长选择器（支持单位 秒 分）](#8)


## 1.单行文本

单行文本的API请参照[输入框](/input)页面的介绍。

## 2.单选按钮
+ 基础用法
```html
<ht-radio v-model="data.xxb.xb"  :options="[{ key: "1", value: "男士"}, { key: "2", value: "女士" }]"/>
```
+ disabled  || readonly 
- 所有选项不可选择可以设置disabled属性或者readonly
```html
 <ht-radio v-model="data.xxb.xb" disabled permission="w" :options="[{ key: "1", value: "男士"}, { key: "2", value: "女士" }]"/>
```
 - 部分选项不可选择  { key: "1", value: "男士",disabled:true}
 ```html
 <ht-radio v-model="data.xxb.xb"  permission="w" :options="[{ key: "1", value: "男士",disabled:true}, { key: "2", value: "女士" }]"/>
```

+ options 说明  
key 支持 String, Number,Boolean  
默认为key  value 
可以通过 :props="{key:'code',value:'desc'}" 设置对应的key value
```html
<ht-radio v-model="data.xxb.xb" permission="w" :options="[{ code: "1", desc: "男士"}, { code: "2", desc: "女士" }]" :props="{key:'code',value:'desc'}" />
```
+ permission 说明  
  permission="w"  为默认值  支持  ["b", "w", "r", "n"] 4种值

+ option-layout 默认值为`horizontal`即选项横向排列，可以设置为`vertical`，则选项垂直排列。
  ```
  <ht-radio option-layout="vertical" ... />
  ```
  
## 3.复选框

+ option-layout 默认值为`horizontal`即选项横向排列，可以设置为`vertical`，则选项垂直排列。
  ```
  <ht-checkbox option-layout="vertical" ... />
  ```
  

## 4.日期时间

## 5.下拉框

+ 支持change事件 返回 选中的对象的key 和选中的对象
this.$emit("change",data,selectObj);
```html
<ht-select
    v-model="data.xxb.zy"
    :options="options.zy"
    :remote-method="handleSelectOptions"
    :validate="{'required':true}"
    :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
    @change="change"
    />
```

+ 基础用法
```html
<ht-select
  v-model="data.xxb.zy"
  :options="[{key:'1',value:'医生'},{key:'2',value:'护士'}]"
  :remote-method="handleSelectOptions"
  :validate="{'required':true}"
></ht-select>
```

+ 默认插槽用法

- 用法一

```html
<ht-select
  v-model="data.xxb.zy"
  :options="[{key:'a',value:'a',children:[ {key:'1',value:'医生'},{key:'2',value:'护士'}]},{key:'水果',value:'水果',children:[ {key:'a',value:'苹果'},{key:'b',value:'香蕉'}]}]"
  :remote-method="handleSelectOptions"
  :validate="{'required':true}"
  :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
>
  <template slot-scope="{ options}">
    <el-option-group v-for="group in options" :key="group.key" :label="group.value">
      <el-option
        v-for="item in group.children"
        :key="item.key"
        :label="item.value"
        :value="item.key"
      ></el-option>
    </el-option-group>
  </template>
</ht-select>
```

- 用法二

```html
<ht-select
  v-model="data.xxb.zy"
  :options="[{key:'a',value:'a',children:[ {key:'1',value:'医生'},{key:'2',value:'护士'}]},{key:'水果',value:'水果',children:[ {key:'a',value:'苹果'},{key:'b',value:'香蕉'}]}]"
  :validate="{'required':true}"
  :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
>
  <template slot-scope="{options,propKey,propValue}">
    <el-option-group v-for="group in options" :key="group.key" :label="group.value">
      <el-option
        v-for="item in group.children"
        :key="item[propKey]"
        :label="item[propValue]"
        :value="item[propKey]"
      ></el-option>
    </el-option-group>
  </template>
</ht-select>
```

- 用法三   可以通过props属性指定key 和 value 

```html
<ht-select
  v-model="data.xxb.zy"
  :options="[{key:'a',value:'a',children:[ {key:'1',value:'医生'},{key:'2',value:'护士'}]},{key:'水果',value:'水果',children:[ {key:'a',value:'苹果'},{key:'b',value:'香蕉'}]}]"
  :props="{key:'alias',value:'name'}"
  :validate="{'required':true}"
>
  <template slot-scope="{options,propKey,propValue}">
    <el-option-group v-for="group in options" :key="group.key" :label="group.value">
      <el-option
        v-for="item in group.children"
        :key="item[propKey]"
        :label="item[propValue]"
        :value="item[propKey]"
      ></el-option>
    </el-option-group>
  </template>
</ht-select>
```

## 6.附件上传

## 7.选择器


## 8.时长选择器
支持 disabled ，validate , type  属性 

type 默认值为 minute   type="second" 或者 type="minute"
```html
 <ht-duration
                v-model="data.xxb.second"
                validate="required"
                
              />
```