/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.report.bigScreen.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.util.CheckFileFormatUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.report.bigScreen.dao.BladeVisualConfigDao;
import com.artfess.report.bigScreen.dao.BladeVisualDao;
import com.artfess.report.bigScreen.manager.BladeVisualManager;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualConfig;
import com.artfess.report.bigScreen.vo.BladeVisualConfigVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BladeVisualManagerImpl
extends BaseManagerImpl<BladeVisualDao, BladeVisual>
implements BladeVisualManager {
    @Autowired
    private BladeVisualConfigDao bladeVisualConfigDao;
    @Value(value="${minio.minio_url}")
    private String minioUrl;

    @Override
    public PageList<BladeVisual> queryBladeVisual(QueryFilter<BladeVisual> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<BladeVisual> result = ((BladeVisualDao)this.baseMapper).queryPage((IPage<BladeVisual>)this.convert2IPage(pageBean), (Wrapper<BladeVisual>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (BladeVisual record : records) {
            if (!StringUtils.isNotBlank((CharSequence)record.getBackgroundUrl()) || record.getBackgroundUrl().startsWith("https")) continue;
            record.setBackgroundUrl(this.minioUrl + record.getBackgroundUrl());
        }
        return new PageList(result);
    }

    @Override
    public String uploadPhoto(MultipartFile positiveFile) throws Exception {
        String uriPhoto = "";
        if (positiveFile != null) {
            String ext = CheckFileFormatUtil.getFileType((FileInputStream)((FileInputStream)positiveFile.getInputStream()));
            if (ext == null) {
                throw new RuntimeException("\u4e0d\u80fd\u8bc6\u522b\u7684\u6587\u4ef6\u683c\u5f0f");
            }
            if ("bmp,jpg,png,tif,gif,svg,jpeg".indexOf(ext) == -1) {
                throw new RuntimeException("\u8bf7\u4e0a\u4f20\u56fe\u7247\u683c\u5f0f\u6587\u4ef6");
            }
            String originalFilename = positiveFile.getOriginalFilename();
            String fileType = originalFilename.substring(originalFilename.lastIndexOf("."));
            uriPhoto = MinioUtil.uploadRelative((MultipartFile)positiveFile, (String)"", (String)(RandomStringUtils.randomAlphanumeric((int)100) + fileType), (String)"big-screen");
        }
        return uriPhoto;
    }

    @Override
    public BladeVisualConfigVo getVisualConfig(String id) {
        BladeVisualConfigVo bladeVisualConfigVo = new BladeVisualConfigVo();
        BladeVisual bladeVisual = (BladeVisual)this.get((Serializable)((Object)id));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(StringUtils.isNotBlank((CharSequence)id), (Object)"visual_id", (Object)id);
        BladeVisualConfig bladeVisualConfig = (BladeVisualConfig)((Object)this.bladeVisualConfigDao.selectOne((Wrapper)wrapper));
        bladeVisualConfigVo.setConfig(bladeVisualConfig);
        bladeVisualConfigVo.setVisual(bladeVisual);
        return bladeVisualConfigVo;
    }

    @Override
    public String saveBladeVisualConfigVo(BladeVisualConfigVo bladeVisualConfigVo) {
        BladeVisual visual = bladeVisualConfigVo.getVisual();
        if (visual != null) {
            visual.setIsDele("0");
            this.save((Object)visual);
            BladeVisualConfig config = bladeVisualConfigVo.getConfig();
            if (config != null) {
                config.setVisualId(visual.getId());
                this.bladeVisualConfigDao.insert((Object)config);
            }
        }
        return visual.getId();
    }

    @Override
    public void updateBladeVisualConfigVo(BladeVisualConfigVo bladeVisualConfigVo) {
        if (bladeVisualConfigVo.getVisual() != null) {
            this.updateById((Object)bladeVisualConfigVo.getVisual());
        }
        if (bladeVisualConfigVo.getConfig() != null) {
            this.bladeVisualConfigDao.updateById((Object)bladeVisualConfigVo.getConfig());
        }
    }
}

