/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.yhxt.specialcheck.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.yhxt.basedata.manager.AccessoryManager;
import com.artfess.yhxt.disease.manager.DiseaseManager;
import com.artfess.yhxt.disease.model.Disease;
import com.artfess.yhxt.specialcheck.dao.SiteInspectionDao;
import com.artfess.yhxt.specialcheck.manager.SiteInspectionManager;
import com.artfess.yhxt.specialcheck.model.SiteInspection;
import com.artfess.yhxt.specialcheck.vo.DefaultBpmCheckOpinionVo;
import com.artfess.yhxt.specialcheck.vo.SiteDiseaseVo;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionDiseaseVo;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionTaskVo;
import com.artfess.yhxt.specialcheck.vo.SiteInspectionVo;
import com.artfess.yhxt.specialcheck.vo.SiteTaskVo;
import com.artfess.yhxt.task.manager.TaskWaitHandleManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class SiteInspectionManagerImpl
extends BaseManagerImpl<SiteInspectionDao, SiteInspection>
implements SiteInspectionManager {
    @Resource
    private DiseaseManager diseaseManager;
    @Resource
    private TaskWaitHandleManager taskWaitHandleManager;
    @Resource
    private BaseContext baseContext;
    @Resource
    private UserManager userManager;
    @Resource
    SysIdentityManager sysIdentityManager;
    @Resource
    AccessoryManager accessoryManager;

    @Override
    public PageList<SiteInspectionVo> querySiteInspection(QueryFilter<SiteInspection> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        IPage<SiteInspectionVo> results = ((SiteInspectionDao)this.baseMapper).querySiteInspectionList((IPage<SiteInspection>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SiteInspection>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = results.getRecords();
        LocalDate today = LocalDate.now();
        for (SiteInspectionVo record : records) {
            LocalDate patrolDate;
            Integer state;
            String rummagerId = record.getRummagerId();
            List<String> rummagerIds = Arrays.asList(rummagerId.split(","));
            QueryWrapper userQueryWrapper = new QueryWrapper();
            userQueryWrapper.in((Object)"ID_", rummagerIds);
            List users = this.userManager.getBaseMapper().selectList((Wrapper)userQueryWrapper);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                String fullname = user.getFullname();
                if (i == 0) {
                    sb.append(fullname);
                    continue;
                }
                sb.append("," + fullname);
            }
            record.setRummagerName(sb.toString());
            String recorderId = record.getRecorderId();
            if (StringUtils.isNotEmpty((CharSequence)recorderId)) {
                User recorderUser = (User)this.userManager.getById((Serializable)((Object)recorderId));
                record.setRecorderName(recorderUser.getFullname());
            }
            record.setIsTimeout(0);
            if (null == record.getHandStatus() || (state = Integer.valueOf(record.getHandStatus())) >= 3 && state != 7 || !today.isAfter(patrolDate = record.getPatrolDate())) continue;
            record.setIsTimeout(1);
        }
        return new PageList(results);
    }

    @Override
    public SiteDiseaseVo getSiteInspectionById(String id) {
        String recorderId;
        SiteDiseaseVo siteDiseaseVo = ((SiteInspectionDao)this.baseMapper).getSiteInspectionById(id);
        SiteInspectionVo siteInspectionVo = siteDiseaseVo.getSiteInspectionVo();
        String rummagerId = siteInspectionVo.getRummagerId();
        if (StringUtils.isNotEmpty((CharSequence)rummagerId)) {
            List<String> rummagerIds = Arrays.asList(rummagerId.split(","));
            QueryWrapper userQueryWrapper = new QueryWrapper();
            userQueryWrapper.in((Object)"ID_", rummagerIds);
            List users = this.userManager.getBaseMapper().selectList((Wrapper)userQueryWrapper);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.get(i);
                String fullname = user.getFullname();
                if (i == 0) {
                    sb.append(fullname);
                    continue;
                }
                sb.append("," + fullname);
            }
            siteInspectionVo.setRummagerName(sb.toString());
        }
        if (StringUtils.isNotEmpty((CharSequence)(recorderId = siteInspectionVo.getRecorderId()))) {
            User recorderUser = (User)this.userManager.getById((Serializable)((Object)recorderId));
            siteInspectionVo.setRecorderName(recorderUser.getFullname());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"RELEVANCE_ID_", (Object)id);
        List diseaseList = this.diseaseManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        if (diseaseList.size() > 0) {
            diseaseList.forEach(s -> s.setAccessories(this.accessoryManager.getAccessoryBySourceId(s.getId())));
        }
        siteDiseaseVo.setDiseaseList(diseaseList);
        return siteDiseaseVo;
    }

    @Override
    public PageList<DefaultBpmCheckOpinionVo> getSiteInspectionStatus(QueryFilter queryFilter) {
        IPage<DefaultBpmCheckOpinionVo> results = ((SiteInspectionDao)this.baseMapper).getSiteInspectionStatus((IPage<SiteInspection>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SiteInspection>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(results);
    }

    @Override
    public PageList<SiteInspectionTaskVo> getSiteInspectionTask(QueryFilter queryFilter) {
        IPage<SiteInspectionTaskVo> results = ((SiteInspectionDao)this.baseMapper).getSiteInspectionTask((IPage<SiteInspection>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<SiteInspection>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(results);
    }

    @Override
    public SiteInspectionDiseaseVo saveSiteDiseaseVo(SiteInspectionDiseaseVo vo) {
        SiteInspection siteInspection = vo.getSiteInspection();
        List<Disease> diseaseList = vo.getDiseaseList();
        this.saveOrUpdate((Object)siteInspection);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"RELEVANCE_ID_", (Object)siteInspection.getId());
        this.diseaseManager.getBaseMapper().delete((Wrapper)queryWrapper);
        this.diseaseManager.saveOrUpdateBatch(diseaseList);
        return vo;
    }

    @Override
    public SiteInspection saveSite(SiteInspection siteInspection) {
        if (!StringUtils.isEmpty((CharSequence)siteInspection.getId())) {
            if (!"1".equals(siteInspection.getHandStatus())) {
                return null;
            }
            this.update((Model)siteInspection);
            SiteInspection updateVo = new SiteInspection();
            updateVo.setId("1");
            return updateVo;
        }
        siteInspection.setHandStatus("1");
        String rummagerId = siteInspection.getRummagerId();
        String currentOrgId = ContextUtil.getCurrentOrgId((String)rummagerId);
        String currentOrgName = ContextUtil.getCurrentOrgName((String)rummagerId);
        this.sysIdentityManager.nextId("xcgdbh");
        this.create((Model)siteInspection);
        String id = siteInspection.getId();
        String bizType = "1";
        this.taskWaitHandleManager.saveTask(siteInspection, bizType);
        return siteInspection;
    }

    @Override
    public void updateSitestatus(SiteTaskVo siteTaskVo) {
        String siteId = siteTaskVo.getSiteId();
        String status = siteTaskVo.getStatus();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (status.equals("2")) {
            updateWrapper.set((Object)"RECORDER_ID_", (Object)this.baseContext.getCurrentUserId());
            updateWrapper.set((Object)"RECORDER_ACCOUNT_", (Object)this.baseContext.getCurrentUserAccout());
        }
        updateWrapper.set((Object)"HAND_STATUS_", (Object)status);
        updateWrapper.eq((Object)"ID_", (Object)siteId);
        this.update(null, (Wrapper)updateWrapper);
        this.taskWaitHandleManager.updateTask(siteTaskVo);
    }

    @Override
    public PageList<SiteInspectionVo> queryTaskHistory(QueryFilter<SiteInspection> queryFilter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map params = queryFilter.getParams();
        if (params != null) {
            map.putAll(params);
        }
        String userId = this.baseContext.getCurrentUserId();
        List<String> ids = ((SiteInspectionDao)this.baseMapper).selectBizId(userId);
        queryFilter.addFilter("a.ID_", ids, QueryOP.IN);
        IPage<SiteInspectionVo> results = ((SiteInspectionDao)this.baseMapper).queryTaskHistory((IPage<SiteInspection>)this.convert2IPage(queryFilter.getPageBean()), map, (Wrapper<SiteInspection>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = results.getRecords();
        for (SiteInspectionVo record : records) {
            String recorderId;
            String rummagerId = record.getRummagerId();
            if (StringUtils.isNotEmpty((CharSequence)rummagerId)) {
                List<String> rummagerIds = Arrays.asList(rummagerId.split(","));
                QueryWrapper userQueryWrapper = new QueryWrapper();
                userQueryWrapper.in((Object)"ID_", rummagerIds);
                List users = this.userManager.getBaseMapper().selectList((Wrapper)userQueryWrapper);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < users.size(); ++i) {
                    User user = (User)users.get(i);
                    String fullname = user.getFullname();
                    if (i == 0) {
                        sb.append(fullname);
                        continue;
                    }
                    sb.append("," + fullname);
                }
                record.setRummagerName(sb.toString());
            }
            if (!StringUtils.isNotEmpty((CharSequence)(recorderId = record.getRecorderId()))) continue;
            User recorderUser = (User)this.userManager.getById((Serializable)((Object)recorderId));
            record.setRecorderName(recorderUser.getFullname());
        }
        return new PageList(results);
    }

    @Override
    public void exportSite(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5de1\u68c0\u4fe1\u606f");
        }
        List<String> siteIds = Arrays.asList(ids.split(","));
        for (String siteId : siteIds) {
            SiteInspection siteInspection = (SiteInspection)((Object)this.getById((Serializable)((Object)siteId)));
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet("\u65e5\u5e38\u5de1\u68c0\u8bb0\u5f55\u8868");
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            HSSFRow row1 = sheet.createRow(1);
            HSSFCell cell1 = row1.createCell(0);
            cell1.setCellValue("\u65e5\u5e38\u5de1\u67e5\u8bb0\u5f55\u8868");
            HSSFRow row2 = sheet.createRow(2);
            HSSFCell cell2 = row2.createCell(0);
            cell2.setCellValue("\u5de1\u67e5\u4e2d\u961f:");
            HSSFCell cell3 = row2.createCell(3);
            cell3.setCellValue("\u65e5\u671f:");
        }
    }
}

