import 'babel-polyfill'
import Vue from 'vue'
import App from './App.vue'
import store from './store'
import router from './router'
import Print from '@/plugs/print' //打印插件 源码修改过 getStyle方法
import '@/assets/css/element-custom.scss'
import ElementUI from 'element-ui'
import i18n from '@/lang/index.js'
import moment from 'moment' //日期格式化插件
import VueUeditorWrap from 'vue-ueditor-wrap' //引入富文本组件
// import echarts from 'echarts' //引入echarts
import HotentUi from 'bpm_el_ui' //引入ui
import 'bpm_el_ui/lib/bpm_el_ui.css'
import 'bpm_el_ui/src/assets/css/element-variables.scss'
import '@/directive.js'
import req from '@/request.js'
import deepmerge from 'deepmerge'
import validate from '@/validate.js'
import dict from '@/lang/dict.js'
import HtSubmitButton from '@/components/common/HtSubmitButton.vue'
import HtDeleteButton from '@/components/common/HtDeleteButton.vue'
import HtLoadData from '@/components/common/HtLoadData.vue'
import AtTable from '@/components/AtTable.vue'
import CommonDialog from '@/components/dialog/CommonDialog.vue'
import VueClipboard from 'vue-clipboard2'
import utils from '@/utils.js'
import Formulas from '@/formulas.js'
import VueAMap from 'vue-amap' //高德地图插件
import AMap from 'vue-amap'

import Viewer from 'v-viewer' //图片预览插件
import 'viewerjs/dist/viewer.css'

//上传组件
import uploader from 'vue-simple-uploader'
Vue.use(uploader)

// 引入vant2
import 'vant/lib/index.css';

import Video from 'video.js'
import 'video.js/dist/video-js.css'
import CollapseTransition from 'element-ui/lib/transitions/collapse-transition'
// 大屏组件
import dataV from '@jiaminghi/data-view'
//引入字典
import DictSelect from '@/components/dict/DictSelect.vue'
import dictUtils from '@/components/dict/DictSelectUtils'
// //引入用户选择器
// import CompanyUserSelector from '@/components/selector/companyUserSelector.vue'

// Vant

import { ContactList, Dialog, ActionSheet, Collapse, CollapseItem,Col, Row, Empty, Form, Tabbar, TabbarItem, NavBar, Icon,Cell, Calendar, DatetimePicker, Popup, Picker, PullRefresh, RadioGroup, Radio, Button, Toast, Checkbox, CheckboxGroup, Field, CellGroup, Switch, Search, Tag, Notify } from 'vant'
Vue.use(NavBar)
Vue.use(Icon)
Vue.use(Cell)
Vue.use(Calendar)
Vue.use(DatetimePicker)
Vue.use(Popup)
Vue.use(Picker)
Vue.use(PullRefresh)
Vue.use(RadioGroup)
Vue.use(Radio)
Vue.use(Button)
Vue.use(Toast)
Vue.use(Checkbox)
Vue.use(CheckboxGroup)
Vue.use(Field)
Vue.use(CellGroup)
Vue.use(Switch)
Vue.use(Search)
Vue.use(Tag)
Vue.use(Notify)
Vue.use(Tabbar);
Vue.use(TabbarItem);
Vue.use(Form);
Vue.use(Empty);
Vue.use(Col);
Vue.use(Row);
Vue.use(Collapse);
Vue.use(CollapseItem);
Vue.use(ActionSheet);
Vue.use(Dialog);
Vue.use(ContactList);


Vue.filter("global_filter", function(value, type = "YYYY-MM-DD hh:mm:ss") {
    return moment(value).format(type);
  });
Vue.filter('formatDate', function(value,pattern = "YYYY-MM-DD HH:mm:ss") {
  if (!value){
    return "";
  }
  return moment(value).format(pattern)
})
Vue.prototype.$moment = moment;//赋值使用

//引入在线wps编辑
import * as WPS from '@/assets/js/web-office-sdk-v1.1.18.es.js'
Vue.prototype.wps = WPS
import console from 'Console'
Vue.prototype.console = console
Vue.use(dataV)
//获取字典名字
Vue.prototype.getDictName = (dictCode, value) => {
  let name = ''
  let dictItems = dictUtils.getDictItemsFromCache(dictCode)
  dictItems &&
    dictItems.forEach((item) => {
      if (item.value == value) {
        name = item.name
      }
    })
  return name
}

//获取字典数据
Vue.prototype.getDictData = (dictCode) => {
  let arr = []
  let dictItems = dictUtils.getDictItemsFromCache(dictCode)
  dictItems &&
    dictItems.forEach((item) => {
      arr.push({
        text: item.name,
        value: item.value,
      })
    })
  return arr
}
//获取字典名字(多选)
Vue.prototype.getDictMultipleName = (dictCode, value) => {
  let str=''
  if(value){
    str=value.indexOf(',')
  }
  let name = ''
  let dictItems = dictUtils.getDictItemsFromCache(dictCode)
  if (str && str == 1) {
    let arr = value.split(',')
    arr.sort().toString()
    let newArr = []
    dictItems && dictItems.forEach((item) => {
      arr.forEach((val) => {
        if (item.value == val) {
          newArr.push(item.name)
        }
      })
    })
    name = newArr.join(',')
  } else {
    dictItems.forEach((item) => {
      if (item.value == value) {
        name = item.name
      }
    })
  }
  return name
}

Vue.prototype.getDictDataSearch = (dictCode) => {
  let arr = []
  let dictItems = dictUtils.getDictItemsFromCache(dictCode)
  dictItems.forEach((item) => {
    arr.push({
      value: item.name,
      key: item.value,
    })
  })
  return arr
}
Vue.prototype.getDate = () => {
  const nowDate = new Date()
  let date = {
    year: nowDate.getFullYear(),
    month: nowDate.getMonth() + 1,
    date: nowDate.getDate(),
  }
  const newmonth = date.month > 10 ? date.month : '0' + date.month
  const day = date.date > 10 ? date.date : '0' + date.date
  date = date.year + '-' + newmonth + '-' + day
  return date
}


// 将数组对象中的某一个属性值单独抽取出来成为一个新的数组  [{id:'1',name:'苹果'},{id:'2',name:'香蕉'}].extractByKey("id") ==> ['1','2']
Array.prototype.extractByKey = function (key) {
  let set = new Set();
  this.forEach(m => {
      if (key && m[key]) {
          set.add(m[key]);
      }
  });
  return Array.from(set);
}

/**
 * 数字金额格式化（千分位）
 * @param {Number} money 要转换的金额数字
 * @param {Number} num 小数点后有效数字
 * @returns
 */
Vue.prototype.moneyFormatter = (money, num) => {
  if (money == null || money == '' || money == undefined) {
    return ''
  }
  num = num > 0 && num <= 20 ? num : 2
  money = parseFloat((money + '').replace(/[^\d.-]/g, '')).toFixed(num) + ''
  let l = money.split('.')[0].split('').reverse(),
    r = money.split('.')[1]
  let t = ''
  for (let i = 0; i < l.length; i++) {
    t += l[i] + ((i + 1) % 3 === 0 && i + 1 != l.length ? ',' : '')
  }
  return t.split('').reverse().join('') + '.' + r
}

//侧边导航事件
import eventBus from './api/bus.js'
Vue.use(eventBus)
//菜单图标
import svgIcon from '@/components/global/svgIcon.vue'

Vue.prototype.$video = Video

Vue.config.debug = true

Vue.prototype.$http = req

Vue.use(AMap)
AMap.initAMapApiLoader({
  // key: 'babe07289a50fc3eda093e6ccea2f8a4',
  key: '7d54f1d3d43901f3c6a728971dd4a9c2', //中铁建亿联-web端	 key值：7d54f1d3d43901f3c6a728971dd4a9c2
  // 可使用服务： JavaScript API  地图组件室内地图  JS API地铁图  JS API
  plugin: [
    'AMap.Autocomplete',
    'AMap.PlaceSearch',
    'AMap.Scale',
    'AMap.OverView',
    'AMap.ToolBar',
    'AMap.MapType',
    'AMap.PolyEditor',
    'AMap.CircleEditor',
    'AMap.Geolocation',
    'AMap.Driving',
    'AMap.Geocoder',
    'AMap.service',
    'AMap.convertFrom',
    'AMap.RoadInfoSearch',
    'Map3D',
    'AMap.DistrictSearch',
    'AMap.Polyline',
  ],
  // 默认高德 sdk 版本为 1.4.4
  v: '1.4.4',
})

// 字符串解析和序列化字符串
import qs from 'qs'
Vue.prototype.qs = qs

Vue.use(Viewer, {
  defaultOptions: {
    zIndex: 9999,
    toolbar: true,
  },
})
Vue.use(VueClipboard)
Vue.use(ElementUI, {
  i18n: (key, value) => i18n.t(key, value),
  size: 'small',
})

Vue.use(HotentUi, {
  i18n: (key, value) => i18n.t(key, value),
})

Vue.use(Print)
Vue.use(Formulas)

// 注册全局组件
Vue.use(VueAMap)
Vue.component('svgIcon', svgIcon)
Vue.component('HtSubmitButton', HtSubmitButton)
Vue.component('HtDeleteButton', HtDeleteButton)
Vue.component('DictSelect', DictSelect)
Vue.component('CommonDialog', CommonDialog)

// Vue.component('CompanyInfoSelector', CompanyInfoSelector)
// Vue.component('CompanyUserSelector', CompanyUserSelector)
Vue.component('HtLoadData', HtLoadData)
Vue.component('AtTable', AtTable)
Vue.filter('formatDate', function (value, pattern = 'YYYY-MM-DD HH:mm:ss') {
  if (!value) {
    return ''
  }
  return moment(value).format(pattern)
})
Vue.component('vue-ueditor-wrap', VueUeditorWrap)
Vue.component(CollapseTransition.name, CollapseTransition)


// Vue.prototype.$echarts = echarts

window.app = new Vue({
  store,
  router,
  i18n,
  render: function (createElement) {
    if (
      '-ms-scroll-limit' in document.documentElement.style &&
      '-ms-ime-align' in document.documentElement.style
    ) {
      window.addEventListener(
        'hashchange',
        () => {
          var currentPath = window.location.hash.slice(1)
          if (this.$route.path !== currentPath) {
            this.$router.push(currentPath)
          }
        },
        false
      )
    }
    return createElement(App)
  },
}).$mount('#root')

export default app;
let validateLocal = localStorage.getItem('lang')
let currentLocal = validateLocal || 'zh-CN'
app.$validator.locale = currentLocal

if (app.$validator) {
  for (let rule in validate) {
    app.$validator.rules[rule] = validate[rule]
  }
  app.$validator.dictionary.container = deepmerge(
    dict,
    app.$validator.dictionary.container,
    {clone: true}
  )
}

// 日期控件格式化
if ('zh-CN' == currentLocal) {
  moment.locale('zh-cn')
} else {
  moment.locale('en')
}

// el-tooltip 默认显示
Vue.prototype.$tooltipplacement = 'bottom'
