package com.artfess.base.enums;

import lombok.Getter;

/**
 * 短信模版
 */
@Getter
public enum MessageTemplateEnum {
    /**
     *
     */
    yl(1, "SMS_22052700007", "雨量预警","【阿特菲斯】"),

    //{name}在{time}，当前水位达到{value}米，超过{warnGrade}阈值{warnVal}米（{stnm}）。
    sw(2, "SMS_22052700009", "水位预警","【阿特菲斯】"),

    wy(3, "SMS_22052600014", "位移预警","【阿特菲斯】"),

    sl(4, "SMS_22052600011", "渗流预警","【阿特菲斯】"),

    sy(5, "SMS_22052600010", "渗压预警","【阿特菲斯】"),

    wa(6, "SMS_22051700021", "取水预警","【阿特菲斯】"),

    slyl(7, "SMS_22052700003", "渗流压力水位","【阿特菲斯】"),
    ;

    MessageTemplateEnum(Integer type, String templateId, String name, String signature){
        this.type = type;
        this.templateId = templateId;
        this.signature = signature;
        this.name = name;
    }

    //预警类型 例如 1、雨量预警短信 2 水位预警短信 3 ..
    private Integer type;
    //模版编号 配置的模版id
    private String templateId;
    //短信签名
    private String signature;
    //短信名称
    private String name;

    //产品名称:云通信短信API产品,开发者无需替换
    public static final String product = "Dysmsapi";
    //产品域名,开发者无需替换
    public static final String domain = "dysmsapi.aliyuncs.com";

    //无需修改,用于格式化鉴权头域,给"X-WSSE"参数赋值
    public static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    //无需修改,用于格式化鉴权头域,给"Authorization"参数赋值
    public static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";

    public static String getCode(Integer type){
        if(null == type){
            return null;
        }
        MessageTemplateEnum[] values = values();
        for (MessageTemplateEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getTemplateId();
            }
        }
        return null;
    }

    public static String getSignature(Integer type){
        if(null == type){
            return null;
        }
        MessageTemplateEnum[] values = values();
        for (MessageTemplateEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getSignature();
            }
        }
        return null;
    }
}
