/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.userassign;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.model.HtObjectNode;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.helper.identity.IConditionCheck;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.exception.UserCalcException;
import com.artfess.bpm.plugin.usercalc.UserCalcHelper;
import com.artfess.bpm.plugin.usercalc.cuserrel.def.ExecutorVar;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserConditionCheck
implements IConditionCheck {
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BoDataService boDataService;

    @Override
    public boolean check(String condition, String mode, BpmUserCalcPluginSession session) {
        try {
            if (StringUtil.isEmpty((String)condition)) {
                return true;
            }
            ObjectNode conditionObj = (ObjectNode)JsonUtil.toJsonNode((String)condition);
            if (!conditionObj.hasNonNull("condition")) {
                return true;
            }
            return this.groovyScriptEngine.executeBoolean(this.calConditions((ArrayNode)conditionObj.get("condition"), session, conditionObj.get("junction").asText()), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UserCalcException("\u4eba\u5458\u6761\u4ef6\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
        }
    }

    private String calConditions(ArrayNode conditionList, BpmUserCalcPluginSession session, String compareType) throws Exception {
        if (conditionList.size() == 0) {
            return "true";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < conditionList.size(); ++i) {
            ObjectNode conditionParam = (ObjectNode)conditionList.get(i);
            if (i != 0) {
                sb.append(this.getCompType(compareType));
            }
            if (conditionParam.findValue("condition") != null) {
                ArrayNode subConditions = (ArrayNode)conditionParam.get("condition");
                sb.append(this.calConditions(subConditions, session, conditionParam.get("junction").asText()));
                continue;
            }
            if (this.calculate(conditionParam, session)) {
                sb.append("true");
                continue;
            }
            sb.append("false");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getCompType(String compareType) {
        if (compareType.equals("and")) {
            return "&&";
        }
        return "||";
    }

    private boolean calculate(ObjectNode condition, BpmUserCalcPluginSession session) throws Exception {
        int ruleType = condition.get("ruleType").asInt();
        if (ruleType == 2) {
            String script = condition.get("script").asText();
            Map<String, Object> variables = session.getVariables();
            Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
            if (BeanUtils.isEmpty(boMap)) {
                BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(variables.get("instanceId_").toString());
                List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
                BpmContextUtil.setBoToContext(boDatas);
                boMap = BpmContextUtil.getBoFromContext();
            }
            if (BeanUtils.isNotEmpty(boMap)) {
                HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
                for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                    newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode(next.getValue()));
                }
                variables.putAll(newMap);
            }
            return this.groovyScriptEngine.executeBoolean(script, variables);
        }
        if (BeanUtils.isEmpty((Object)condition.get("expression"))) {
            return true;
        }
        String expression = condition.get("expression").asText();
        ObjectNode executorVarJson = (ObjectNode)condition.get("executorVar");
        ExecutorVar executorVar = (ExecutorVar)JsonUtil.toBean((JsonNode)executorVarJson, ExecutorVar.class);
        String executorVarValue = executorVar.getValue();
        List<String> keys = UserCalcHelper.calcVarValue(executorVar, session, false);
        String variable = StringUtil.join((String[])keys.toArray(new String[0])).trim();
        if ("notEquals".equals(expression)) {
            return !executorVarValue.equals(variable);
        }
        if ("equals".equals(expression)) {
            return executorVarValue.equals(variable);
        }
        if ("contains".equals(expression)) {
            return executorVarValue.contains(variable);
        }
        if ("notContains".equals(expression)) {
            return !executorVarValue.contains(variable);
        }
        String dataType = condition.get("dataType").asText();
        boolean isDate = "date".equals(dataType);
        if (isDate) {
            LocalDateTime date = TimeUtil.getDateTimeByTimeString((String)executorVarValue);
            LocalDate valueData = TimeUtil.getDateTimeByTimeString((String)variable).toLocalDate();
            int diff = TimeUtil.getSecondDiff((LocalDateTime)valueData.atStartOfDay(), (LocalDateTime)date);
            if (">".equals(expression)) {
                return diff > 0;
            }
            if ("<".equals(expression)) {
                return diff < 0;
            }
            if ("<=".equals(expression)) {
                return diff <= 0;
            }
            if (">=".equals(expression)) {
                return diff >= 0;
            }
        }
        return this.groovyScriptEngine.executeBoolean(executorVarValue + expression + variable, session.getVariables());
    }
}

