package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.jaxb.LocalDateTimeAdapter;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;

/**
 * portal_sys_app
 * <pre>
 * 描述：portal_sys_app 实体对象
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-20 15:17:18
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@XmlRootElement(name = "sysApp")
@XmlAccessorType(XmlAccessType.FIELD)
@TableName("portal_sys_app")
@ApiModel(value = "SysApp", description = "portal_sys_app")
public class SysApp extends BaseModel<SysApp> {

    public static final Short IS_PUBLISH = 1;
    public static final Short NOT_PUBLISH = 0;

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @XmlAttribute(name = "name")
    @TableField("NAME_")
    @ApiModelProperty(value = "应用名称")
    protected String name;

    @XmlAttribute(name = "icon")
    @TableField("ICON_")
    @ApiModelProperty(value = "图标")
    protected String icon;

    @XmlAttribute(name = "iconColor")
    @TableField("ICON_COLOR_")
    @ApiModelProperty(value = "图标颜色")
    protected String iconColor;

    @XmlAttribute(name = "type")
    @TableField("TYPE_")
    @ApiModelProperty(value = "类型")
    protected Short type;

    @XmlTransient
    @TableField("MENU_ID_")
    @ApiModelProperty(value = "前台菜单ID")
    protected String menuId;

    @XmlAttribute(name = "sn")
    @TableField("SN_")
    @ApiModelProperty(value = "顺序")
    protected Integer sn;

    @XmlAttribute(name = "content")
    @TableField("CONTENT_")
    @ApiModelProperty(value = "内容")
    protected String content;

    @XmlAttribute(name = "createTime")
    @XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
    @TableField(value = "CREATE_TIME_", fill = FieldFill.INSERT)
    @ApiModelProperty(value = "创建时间")
    protected LocalDateTime createTime;

    @XmlAttribute(name = "updateTime")
    @XmlJavaTypeAdapter(LocalDateTimeAdapter.class)
    @TableField(value = "UPDATE_TIME_", fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(value = "更新时间")
    protected LocalDateTime updateTime;

    @XmlAttribute(name = "createBy")
    @TableField("CREATE_BY_")
    @ApiModelProperty(value = "创建人")
    protected String createBy;

    @XmlAttribute(name = "updateBy")
    @TableField("UPDATE_BY_")
    @ApiModelProperty(value = "更新人")
    protected String updateBy;

    @XmlTransient
    @TableField("TENANT_ID_")
    @ApiModelProperty(value = "租户ID")
    protected String tenantId;

    @XmlAttribute(name = "isPublish")
    @TableField("IS_PUBLISH_")
    @ApiModelProperty(value = "是否发布")
    protected Short isPublish;

    /**
     * portal_sys_menu表的alias_字段
     */
    @XmlAttribute(name = "menuAlias")
    @TableField(exist = false)
    @ApiModelProperty(value = "前台菜单alias")
    protected String menuAlias;

    /**
     * content字段中"表单列表/自定义视图/图表/表单/流程模块/流程"的"编码/别名/key"
     */
    @XmlAttribute(name = "contentAlias")
    @TableField(exist = false)
    @ApiModelProperty(value = "content字段中\"表单列表/自定义视图/图表/表单/流程模块/流程\"的\"编码/别名/key\"")
    protected String contentAlias;

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 返回 主键
     *
     * @return
     */
    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 返回 应用名称
     *
     * @return
     */
    public String getName() {
        return this.name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * 返回 图标
     *
     * @return
     */
    public String getIcon() {
        return this.icon;
    }

    public void setIconColor(String iconColor) {
        this.iconColor = iconColor;
    }

    /**
     * 返回 图标颜色
     *
     * @return
     */
    public String getIconColor() {
        return this.iconColor;
    }

    public void setType(Short type) {
        this.type = type;
    }

    /**
     * 返回 类型
     *
     * @return
     */
    public Short getType() {
        return this.type;
    }

    public String getMenuId() {
        return menuId;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    /**
     * 返回 顺序
     *
     * @return
     */
    public Integer getSn() {
        return this.sn;
    }

    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 返回 内容
     *
     * @return
     */
    public String getContent() {
        return this.content;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    /**
     * 返回 创建时间
     *
     * @return
     */
    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 返回 更新时间
     *
     * @return
     */
    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    /**
     * 返回 创建人
     *
     * @return
     */
    public String getCreateBy() {
        return this.createBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 返回 更新人
     *
     * @return
     */
    public String getUpdateBy() {
        return this.updateBy;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /**
     * 返回 租户ID
     *
     * @return
     */
    public String getTenantId() {
        return this.tenantId;
    }

    public Short getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Short isPublish) {
        this.isPublish = isPublish;
    }

    public String getMenuAlias() {
        return menuAlias;
    }

    public void setMenuAlias(String menuAlias) {
        this.menuAlias = menuAlias;
    }

    public String getContentAlias() {
        return contentAlias;
    }

    public void setContentAlias(String contentAlias) {
        this.contentAlias = contentAlias;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", this.id)
                .append("name", this.name)
                .append("icon", this.icon)
                .append("iconColor", this.iconColor)
                .append("type", this.type)
                .append("sn", this.sn)
                .append("content", this.content)
                .append("createTime", this.createTime)
                .append("updateTime", this.updateTime)
                .append("createBy", this.createBy)
                .append("updateBy", this.updateBy)
                .append("tenantId", this.tenantId)
                .toString();
    }
}