package com.artfess.portal.kh.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 考核结果详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@ApiModel(value="KhResultDetails对象", description="考核结果详情")
public class KhResultDetails extends BaseModel<KhResultDetails> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "结果ID")
    @TableField("result_id_")
    private String resultId;

    @ApiModelProperty(value = "指标科目ID")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "指标性质【字典】（1：量化指标，2：非量化指标）")
    @TableField("nature_")
    private String nature;

    @ApiModelProperty(value = "指标名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "指标编码")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "指标定义(考核说明)")
    @TableField("contents_")
    private String contents;

    @ApiModelProperty(value = "计算方法（评分标准）")
    @TableField("mode_")
    private String mode;

    @ApiModelProperty(value = "目标值")
    @TableField("target_value_")
    private BigDecimal targetValue;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "权重值（不大于1）")
    @TableField("weight_")
    private BigDecimal weight;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "实际值")
    @TableField("actual_value_")
    private BigDecimal actualValue;

    @ApiModelProperty(value = "实际得分")
    @TableField("actual_score_")
    private BigDecimal actualScore;

    @ApiModelProperty(value = "考核备注")
    @TableField("memo_")
    private String memo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResultId() {
        return resultId;
    }

    public void setResultId(String resultId) {
        this.resultId = resultId;
    }

    public String getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public String getNature() {
        return nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getContents() {
        return contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public BigDecimal getTargetValue() {
        return targetValue;
    }

    public void setTargetValue(BigDecimal targetValue) {
        this.targetValue = targetValue;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public BigDecimal getActualValue() {
        return actualValue;
    }

    public void setActualValue(BigDecimal actualValue) {
        this.actualValue = actualValue;
    }

    public BigDecimal getActualScore() {
        return actualScore;
    }

    public void setActualScore(BigDecimal actualScore) {
        this.actualScore = actualScore;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "KhResultDetails{" +
            "id=" + id +
            ", resultId=" + resultId +
            ", subjectId=" + subjectId +
            ", nature=" + nature +
            ", name=" + name +
            ", code=" + code +
            ", contents=" + contents +
            ", mode=" + mode +
            ", targetValue=" + targetValue +
            ", unit=" + unit +
            ", weight=" + weight +
            ", sn=" + sn +
            ", actualValue=" + actualValue +
            ", actualScore=" + actualScore +
            ", memo=" + memo +
        "}";
    }
}
