package com.artfess.portal.kh.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.portal.kh.manager.KhIndicatorsLibraryManager;
import com.artfess.portal.kh.model.KhIndicatorsLibrary;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 考核指标库 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Slf4j
@RestController
@Api(tags = "绩效考核-考核指标库")
@RequestMapping("/kh/indicators/library/")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class KhIndicatorsLibraryController extends BaseController<KhIndicatorsLibraryManager, KhIndicatorsLibrary> {

}
