package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysMenuManager;
import com.artfess.sysConfig.persistence.manager.SysRoleAuthManager;
import com.artfess.sysConfig.persistence.manager.SysSwiftMenuManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysRoleAuth;
import com.artfess.sysConfig.persistence.model.SysSwiftMenu;
import com.artfess.sysConfig.persistence.param.SysRoleAuthParam;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;

/**
 * <pre>
 * 描述：用户自定义菜单 控制器类
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2018-07-3 09:29:59
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/sys/sysSwiftMenu/v1")
@Api(tags = "用户自定义菜单")
@ApiGroup(group = {ApiGroupConsts.GROUP_SYSTEM})
public class SysSwiftMenuController extends BaseController<SysSwiftMenuManager, SysSwiftMenu> {


    @RequestMapping(value = "save", method = RequestMethod.POST)
    @ApiOperation(value = "保存用户自定义菜单信息", httpMethod = "POST", notes = "用户自定义菜单信息")
    public CommonResult<String> save(@ApiParam(name = "menuAlias", value = "菜单别名", required = true) @RequestParam String menuAlias) throws Exception {
        String resultMsg = null;
        String id = baseService.insertSwiftMenus(menuAlias);
        if(StringUtil.isEmpty(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, menuAlias);
        }
        resultMsg = "保存成功";
        return new CommonResult<String>(true, resultMsg);
    }


    @RequestMapping(value = "removeSwiftMenus", method = RequestMethod.DELETE)
    @ApiOperation(value = "删除用户自定义菜单", httpMethod = "DELETE", notes = "删除用户自定义菜单")
    public CommonResult<String> removeSwiftMenus(@ApiParam(name = "menuAlias", value = "菜单别名", required = true) @RequestParam String menuAlias) throws Exception {
        this.baseService.removeSwiftMenus(menuAlias);
        return new CommonResult<String>(true, "删除用户自定义菜单");
    }

    @RequestMapping(value = "getSwiftMenus", method = RequestMethod.GET)
    @ApiOperation(value = "获取用户自定义菜单", httpMethod = "GET", notes = "获取用户自定义菜单")
    public List<SysMenu> getSwiftMenus() throws Exception {
        List<SysMenu> lists = this.baseService.getSwiftMenus(ContextUtil.getCurrentUserId());
        return lists;
    }

    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "修改自定义菜单排序号", httpMethod = "POST", notes = "修改自定义菜单排序号")
    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        this.baseService.updateSequence(params);
        return new CommonResult<>(true, "排序完成");
    }

}
