package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 所属水系
 */
@Getter
public enum SxTypeEnum {
    ONE("1", "嘉陵江水系"),

    TWO("2", "岷、沱江水系"),

    THREE("3", "汉江水系"),

    FOUR("4", "乌江水系"),

    FIVE("5","长江上游干河流区间水系"),
    ;

    SxTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        SxTypeEnum[] values = values();
        for (SxTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
