package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 工程任务
 */
@Getter
public enum EngTaskEnum {
    ONE("1", "防洪"),

    TWO("2", "防潮"),

    ;

    EngTaskEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        EngTaskEnum[] values = values();
        for (EngTaskEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
