'use strict';

const SockJS = require('sockjs-client/dist/sockjs');

let retries = 0;
let sock = null;

function socket(url, handlers) {
  sock = new SockJS(url);

  sock.onopen = function onopen() {
    retries = 0;
  };

  sock.onclose = function onclose() {
    if (retries === 0) { handlers.close(); }

    // Try to reconnect.
    sock = null;

    // After 10 retries stop trying, to prevent logspam.
    if (retries <= 10) {
      // Exponentially increase timeout to reconnect.
      // Respectfully copied from the package `got`.
      // eslint-disable-next-line no-mixed-operators, no-restricted-properties
      const retryInMs = 1000 * Math.pow(2, retries) + Math.random() * 100;
      retries += 1;

      setTimeout(function cb() {
        socket(url, handlers);
      }, retryInMs);
    }
  };

  sock.onmessage = function onmessage(e) {
    // This assumes that all data sent via the websocket is JSON.
    const msg = JSON.parse(e.data);
    if (handlers[msg.type]) { handlers[msg.type](msg.data); }
  };
}

module.exports = socket;
