package com.artfess.report.bigScreen.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.report.bigScreen.model.BladeVisual;
import com.artfess.report.bigScreen.model.BladeVisualCategory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 可视化分类表 服务类
 *
 * @company 阿特菲斯
 * @author 向贞好
 * @since 2021-07-12
 */
public interface BladeVisualCategoryManager extends BaseManager<BladeVisualCategory> {

    PageList<BladeVisualCategory> queryBladeVisualCategory(QueryFilter<BladeVisualCategory> queryFilter);

    void updateBatchBladeVisualCategory(String id);

    /**
     * 检查是否已经存在该分类
     * @param bladeVisualCategory
     */
    void checkByCategoryValue(BladeVisualCategory bladeVisualCategory);

    List<BladeVisual> getVisual(String categoryValue);
    //IPage<BladeVisual> getVisual(Page<BladeVisual> page, @Param(Constants.WRAPPER) Wrapper query);
}
