/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizMaterial/v1/"})
@Api(tags={"\u4f01\u4e1a\u7269\u6599\u5e93"})
@ApiGroup(group={"group_biz"})
public class BizMaterialController
extends BaseController<BizMaterialManager, BizMaterial> {
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private EnterpriseManager enterpriseManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizMaterial>> queryByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterial> queryFilter) {
        BizUtils.addFilterByHisOrgCodeAndRole(queryFilter, this.ucFeignService, "MAT_COMPANY_CODE_", this.enterpriseManager);
        PageList<BizMaterial> result = ((BizMaterialManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageCurOrgData"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u6570\u636e")
    public CommonResult<PageList<BizMaterial>> pageCurOrgData(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterial> queryFilter) {
        IGroup org = ContextUtil.getCurrentGroup();
        if (BeanUtils.isEmpty((Object)org)) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)new PageList());
        }
        Enterprise enterprise = this.enterpriseManager.getByOrgIdOrCode(org.getGroupId(), org.getGroupCode());
        queryFilter.addFilter("MAT_COMPANY_CODE_", (Object)org.getGroupCode(), QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
        if (BeanUtils.isNotEmpty((Object)((Object)enterprise)) && BeanUtils.isNotEmpty((Object)enterprise.getHistoryCompanyCode())) {
            queryFilter.addFilter("MAT_COMPANY_CODE_", (Object)enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR, "orgQuery");
        }
        PageList<BizMaterial> result = ((BizMaterialManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<BizMaterial>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterial> queryFilter) {
        PageList<BizMaterial> result = ((BizMaterialManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="M-\u6839\u636eid\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizMaterial> selectOne(@RequestParam(value="id") String id) {
        BizMaterial result = (BizMaterial)((Object)((BizMaterialManager)this.baseService).getById((Serializable)((Object)id)));
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="M-\u6dfb\u52a0\u6216\u4fee\u6539\u7269\u6599")
    public CommonResult save(@RequestBody BizMaterial material) {
        String message = "\u64cd\u4f5c\u6210\u529f";
        if (material.getMatType() == 2) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizMaterial::getMatType, (Object)2)).eq(BizMaterial::getMatCode, (Object)material.getMatCode())).eq(BizMaterial::getMatCompanyId, (Object)material.getMatCompanyId());
            if (((BizMaterialManager)this.baseService).count((Wrapper)wrapper) > 0) {
                throw new BaseException("\u4f01\u4e1a\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u8bbe\u5907\u7f16\u53f7\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5");
            }
        }
        ((BizMaterialManager)this.baseService).saveOrUpdate((Object)material);
        return new CommonResult(true, message);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u7269\u6599")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((BizMaterialManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/exportExcelData"})
    @ApiOperation(value="M-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981")
    public CommonResult exportExcelData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterial> queryFilter, HttpServletResponse response) throws Exception {
        ((BizMaterialManager)this.baseService).exportExcelData(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }

    @PostMapping(value={"/updateMatCategory"})
    @ApiOperation(value="M-\u6839\u636eid\u96c6\u5408\u4fee\u6539\u7269\u6599\u5206\u7c7b")
    public CommonResult updateMatCategory(@RequestBody List<String> ids, @RequestParam String categoryCode) {
        if (BeanUtils.isEmpty(ids) || ids.size() <= 0) {
            throw new BaseException("\u8bf7\u9009\u62e9\u7269\u6599");
        }
        ((BizMaterialManager)this.baseService).updateMatCategory(ids, categoryCode);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/updateMatStatus"})
    @ApiOperation(value="M-\u4fee\u6539\u7269\u6599\u72b6\u6001")
    public CommonResult updateMatStatus(@RequestBody List<String> ids, @RequestParam String status) {
        if (BeanUtils.isEmpty(ids) || ids.size() <= 0) {
            throw new BaseException("\u8bf7\u9009\u62e9\u7269\u6599");
        }
        ((BizMaterialManager)this.baseService).updateMatStatus(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }
}

