import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '企业名称',
            prop: 'enterpriseName',
            type: 'input',
            span: 4,
            value: ''
        },
    ]
    const columnsList: COption[] = [
        {
            title: '企业名称',
            prop: 'enterpriseName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '统一社会信用代码',
            prop: 'companyOrgcode',
            minWidth: 250,
            sortable: true
        },
        {
            title: '法定代表人',
            prop: 'companyEbe',
            minWidth: 120,
            sortable: true
        },
        {
            title: '成立日期',
            prop: 'companyRegdate',
            minWidth: 120,
            sortable: true
        },
        {
            title: '注册资本',
            prop: 'registeredCapital',
            minWidth: 120,
            sortable: true
        },
        {
            title: '住所',
            prop: 'companyAddr',
            minWidth: 120,
            sortable: true
        },
        {
            title: '创建时间',
            prop: 'createTime',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
