import req from '@/request.js'

import {setSorterDirection} from '@/utils/requestWrappers'
import {mapState} from 'vuex'

export const TableMixin = {
  data() {
    return {
      portal: window.context.portal,
      loading: false,
      tableMaxHeight: 530,
      showMore: false,
      tableData: [],
      multipleSelection: [], // 复选框
      total: 0,
      queryParam: {
        pageBean: {
          pageSize: 20,
          page: 1
        },
        params: {},
        querys: []
      },
      dialogs: {},
      rowInfo: {},
      noLoadData: false, // 是否初始化加载数据
      isCalcTableHeight: true // 是否计算表格高度
    }
  },
  computed: {
    ...mapState({
      isCharge: state => state.user.currentUserDetail?.user.isCharge || 0
    })
  },
  mounted() {
    if (!this.noLoadData) this.loadData()
    if (this.isCalcTableHeight) {
      this.calcTableHeight()
      this.$root.$on('resize', () => {
        this.calcTableHeight(500)
      })
    }
  },
  methods: {
    handleAdd() {
      this.$refs.formModal.add()
    },
    handleUpdate(row) {
      this.$refs.formModal.edit(row)
    },
    handleDelete() {
      // 批量删除
      req
        .remove(
          this.portal + this.url.delete + '?ids=' + this.multipleSelection
        )
        .then(res => {
          this.$notify({
            type: 'success',
            message: '删除成功',
            duration: 2000
          })
          this.loadData()
        })
    },
    handleDbClick(row, column, event) {
      this.handleUpdate(row)
    },
    handleReset() {
      this.queryParam.params = {}
      this.queryParam.querys = []
      this.clearQuerys && this.clearQuerys()
      this.handleSearch()
    },
    handleSearch() {
      this.queryParam.pageBean.page = 1
      this.loadData()
    },
    handleSizeChange(val) {
      this.queryParam.pageBean.pageSize = val
      this.loadData(1)
    },
    handleCurrentChange(val) {
      this.queryParam.pageBean.page = val
      this.loadData()
    },
    handleSelectionChange(val) {
      this.multipleSelection = val.map(item => item.id)
    },
    commonPageClick() {
      if (this.showMore) {
        this.showMore = false
      }
    },
    calcTableHeight(delay) {
      // 动态计算表格的高度，自适应当前容器
      setTimeout(() => {
        if (!this.$refs.contentPanel) {
          return
        }
        const contentPanelHeight = this.$refs.contentPanel.clientHeight
        const btnPanelHeight = this.$refs.btnPanel.clientHeight || 0
        const paginationPanelHeight = this.$refs.paginationPanel ? 32 : 0
        // (this.$refs.paginationPanel &&
        //     this.$refs.paginationPanel.clientHeight) ||
        // 0;
        this.tableMaxHeight =
          contentPanelHeight - btnPanelHeight - paginationPanelHeight - 42
      }, delay || 0)
    },

    /*以下为重写方法*/
    // 排序切换
    sortChange({prop, order}) {
      this.queryParam.pageBean.page = 1
      let direction = ''
      switch (order) {
        case 'ascending':
          direction = 'ASC'
          break
        case 'descending':
          direction = 'DESC'
          break
      }
      setSorterDirection(this.queryParam, prop, direction)
      this.loadData()
    },

    // 展示弹层
    showDialog(dialogName, val = {}, objKey = 'rowInfo') {
      if (!dialogName) return
      dialogName = dialogName + 'Dialog'
      if (typeof this.dialogs[dialogName] === 'undefined') {
        this.$set(this.dialogs, dialogName, true)
      } else {
        this.dialogs[dialogName] = true
      }
      this[objKey] = val
    }
  }
}
