/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.jms.JmsActor;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.NodeNotifyEvent;
import com.artfess.bpm.api.event.NodeNotifyModel;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.model.form.DefaultForm;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.model.form.FormCategory;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class NodeNotifyEventListener
implements ApplicationListener<NodeNotifyEvent>,
Ordered {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    NatTaskService natTaskService;
    @Resource
    FreeMarkerEngine freeMarkerEngine;

    public void onApplicationEvent(NodeNotifyEvent nodeNotifyEvent) {
        NodeNotifyModel model = (NodeNotifyModel)nodeNotifyEvent.getSource();
        String defId = model.getBpmDefId();
        try {
            Map<String, ObjectNode> map;
            BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
            ArrayNode nodes = JsonUtil.getMapper().createArrayNode();
            ArrayList<Form> formList = new ArrayList<Form>();
            ArrayList<NodeProperties> properties = new ArrayList<NodeProperties>();
            HashMap<String, List<Button>> btnMap = new HashMap<String, List<Button>>();
            HashMap<String, ObjectNode> nodeScriptMap = new HashMap<String, ObjectNode>();
            this.handNodeDefSetting("", bpmProcessDefExt.getBpmnNodeDefs(), properties, formList, nodes, btnMap, nodeScriptMap);
            ActionCmd cmd = ContextThreadUtil.getActionCmd();
            ObjectNode node = null;
            String busData = cmd.getBusData();
            if (StringUtil.isNotEmpty((String)busData)) {
                node = (ObjectNode)JsonUtil.toJsonNode((String)busData);
            }
            if (node == null && BeanUtils.isNotEmpty(map = BpmContextUtil.getBoFromContext())) {
                node = (ObjectNode)JsonUtil.toJsonNode(map);
            }
            if (node == null) {
                return;
            }
            this.initModel(model, model.getTask(), cmd);
            this.getVars(model);
            for (NodeProperties property : properties) {
                String content;
                ArrayList<Object> actors;
                JmsActor actor;
                ObjectNode n;
                JmsActor props;
                String prop;
                if (!property.getNodeId().equals(model.getNodeId()) || !StringUtil.isNotEmpty((String)model.getTiming()) || !model.getTiming().equals(property.getSendType())) continue;
                if (!"null".equals(property.getEmail()) && BeanUtils.isNotEmpty((Object)property.getEmail())) {
                    prop = property.getEmail();
                    props = prop.split("\\.");
                    n = node;
                    for (String p : props) {
                        n = n.get(p);
                    }
                    actor = new JmsActor();
                    actors = new ArrayList<JmsActor>();
                    actor.setEmail(n.asText());
                    actors.add(actor);
                    model.setJmsActors(actors);
                    content = this.parseHtmlContent(property.getTemplate(), model.getVars());
                    model.setContent(content);
                    MessageUtil.sendMsg(model, "mail", "");
                }
                if (!"null".equals(property.getPhone()) || !BeanUtils.isNotEmpty((Object)property.getPhone()) || !property.getNodeId().equals(model.getNodeId())) continue;
                prop = property.getPhone();
                props = prop.split("\\.");
                n = node;
                for (String p : props) {
                    n = n.get(p);
                }
                actor = new JmsActor();
                actors = new ArrayList();
                actor.setMobile(n.asText());
                actors.add(actor);
                model.setJmsActors(actors);
                content = this.parseHtmlContent(property.getTemplate(), model.getVars());
                model.setContent(content);
                MessageUtil.sendMsg(model, "sms", "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initModel(NodeNotifyModel model, BpmDelegateTask task, ActionCmd cmd) {
        model.setTaskId(task.getId());
        model.setBpmnInstId(task.getProcessInstanceId());
        model.setSubject((String)task.getVariable("subject_"));
        model.setNodeId(task.getTaskDefinitionKey());
        model.setNodeName(task.getName());
        model.setProcInstId(task.getProcessInstanceId());
        model.setBpmnDefId(task.getBpmnDefId());
        model.setVars(task.getVariables());
        model.setActionType(ActionType.APPROVE);
        model.setActionName(cmd.getActionName());
        if (cmd instanceof TaskFinishCmd) {
            model.setOpinion(((TaskFinishCmd)cmd).getApprovalOpinion());
        }
    }

    private void getVars(NodeNotifyModel model) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        model.addVars("baseUrl", baseUrl).addVars("taskSubject", model.getSubject()).addVars("taskId", model.getTaskId()).addVars("cause", model.getOpinion()).addVars("nodeName", model.getNodeName()).addVars("agent", BeanUtils.isEmpty((Object)model.getAgent()) ? "" : model.getAgent().getFullname()).addVars("instSubject", model.getSubject()).addVars("instId", taskCmd.getInstId());
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars().get("processInstance");
        if (BeanUtils.isNotEmpty((Object)defaultBpmProcessInstance)) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            model.addVars("bpmName", defaultBpmProcessInstance.getProcDefName()).addVars("date", defaultBpmProcessInstance.getCreateTime().format(dateTimeFormatter)).addVars("creator", defaultBpmProcessInstance.getCreator());
        }
    }

    private void handNodeDefSetting(String parentDefKey, List<BpmNodeDef> nodeDefList, List<NodeProperties> properties, List<Form> formList, ArrayNode nodes, Map<String, List<Button>> btnMap, Map<String, ObjectNode> nodeScriptMap) throws IOException {
        for (BpmNodeDef nodeDef : nodeDefList) {
            Map<ScriptType, String> scriptMap;
            String nodeId = nodeDef.getNodeId();
            NodeType type = nodeDef.getType();
            if (NodeType.START.equals((Object)type) || NodeType.CUSTOMSIGNTASK.equals((Object)type) || NodeType.USERTASK.equals((Object)type) || NodeType.SIGNTASK.equals((Object)type)) {
                ObjectNode node = JsonUtil.getMapper().createObjectNode();
                node.put("name", nodeDef.getName());
                node.put("nodeId", nodeId);
                node.put("type", nodeDef.getType().toString());
                nodes.add((JsonNode)node);
                Form form = null;
                Form mobileForm = null;
                NodeProperties propertie = null;
                if (StringUtil.isEmpty((String)parentDefKey) || "local_".equals(parentDefKey)) {
                    propertie = nodeDef.getLocalProperties();
                    form = nodeDef.getForm();
                    mobileForm = nodeDef.getMobileForm();
                } else {
                    propertie = nodeDef.getPropertiesByParentDefKey(parentDefKey);
                    form = nodeDef.getSubForm(parentDefKey, FormType.PC);
                    mobileForm = nodeDef.getSubForm(parentDefKey, FormType.MOBILE);
                }
                if (propertie != null) {
                    propertie.setNodeId(nodeId);
                    properties.add(propertie);
                }
                if (form == null) {
                    form = new DefaultForm();
                    form.setType(FormCategory.INNER);
                }
                if (mobileForm == null) {
                    mobileForm = new DefaultForm();
                    mobileForm.setFormType(FormType.MOBILE.value());
                }
                form.setNodeId(nodeId);
                mobileForm.setNodeId(nodeId);
                formList.add(mobileForm);
                formList.add(form);
                List<Button> buttons = nodeDef.getButtons();
                btnMap.put(nodeDef.getNodeId(), buttons);
            } else if (NodeType.SUBPROCESS.equals((Object)type)) {
                SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)nodeDef;
                BpmProcessDef<? extends BpmProcessDefExt> processDef = subProcessNodeDef.getChildBpmProcessDef();
                List<BpmNodeDef> bpmNodeDefs = processDef.getBpmnNodeDefs();
                this.handNodeDefSetting(parentDefKey, bpmNodeDefs, properties, formList, nodes, btnMap, nodeScriptMap);
            }
            if ((scriptMap = nodeDef.getScripts()).isEmpty()) continue;
            nodeScriptMap.put(nodeId, (ObjectNode)JsonUtil.toJsonNode(scriptMap));
        }
    }

    public String parseHtmlContent(String html, Map<String, Object> vars) {
        String content = "";
        try {
            content = this.freeMarkerEngine.parseByTemplate(html, vars);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public int getOrder() {
        return 1;
    }
}

