/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataShare.dao.BizShareFilesDao;
import com.artfess.dataShare.dataShare.manager.BizShareAuthManager;
import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.util.HuaweiyunOssUtil;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizShareFilesManagerImpl
extends BaseManagerImpl<BizShareFilesDao, BizShareFiles>
implements BizShareFilesManager {
    @Resource
    private BizShareTableManager tableManager;
    @Resource
    private BizShareConsumerManager consumerManager;
    @Resource
    private BizShareAuthManager authManager;
    @Resource
    private DatabaseContext databaseContext;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private SysDataSourceManager dataSourceManager;

    @Override
    public boolean saveInfo(BizShareFiles file) {
        if (!this.check(file)) {
            throw new ApplicationException("\u5171\u4eab\u8d44\u6e90\u6587\u4ef6\u540d\u79f0\u3010" + file.getFileName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        String tableId = file.getTableId();
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)tableId));
        file.setDbAlias(table.getDbAlias());
        file.setIsCreate("0");
        return this.save((Object)file);
    }

    @Override
    public boolean updateInfo(BizShareFiles file) {
        if (!this.check(file)) {
            throw new ApplicationException("\u5171\u4eab\u8d44\u6e90\u6587\u4ef6\u540d\u79f0\u3010" + file.getFileName() + "\u3011\u5df2\u5b58\u5728\uff01");
        }
        return this.updateById((Object)file);
    }

    @Override
    public boolean uploadFile(HttpServletResponse response, HttpServletRequest request, String id) {
        int i;
        BizShareFiles file = (BizShareFiles)((Object)((BizShareFilesDao)this.baseMapper).selectById((Serializable)((Object)id)));
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)file.getTableId()));
        String sql = file.getFileSql();
        String dbAlias = table.getDbAlias();
        List result = new ArrayList();
        try (DatabaseSwitchResult databaseSwitchResult = this.databaseContext.setDataSource(dbAlias);){
            result = this.jdbcTemplate.queryForList(sql);
        }
        catch (Exception e) {
            throw new ApplicationException();
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        Sheet sheet = workbook.createSheet("sheet1");
        Row header = sheet.createRow(0);
        Map headerMap = (Map)result.get(0);
        Set headerKeySet = headerMap.keySet();
        List headerKeyList = headerKeySet.stream().collect(Collectors.toList());
        for (i = 0; i < headerKeyList.size(); ++i) {
            String key = (String)headerKeyList.get(i);
            Cell cell = header.createCell(i);
            cell.setCellValue(key);
        }
        for (i = 0; i < result.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            Map resultMap = (Map)result.get(i);
            Set keySet = resultMap.keySet();
            List keyList = keySet.stream().collect(Collectors.toList());
            for (int j = 0; j < keyList.size(); ++j) {
                String key = (String)keyList.get(j);
                Cell cell = row.createCell(j);
                String value = resultMap.get(key).toString();
                cell.setCellValue(value);
            }
        }
        String path = "dataShare/" + file.getFileName();
        ByteArrayInputStream in = null;
        String backUrl = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            workbook.close();
            in = new ByteArrayInputStream(out.toByteArray());
            HwObsSetting hwObsSetting = (HwObsSetting)AppUtil.getBean(HwObsSetting.class);
            hwObsSetting.initObs();
            backUrl = HuaweiyunOssUtil.uploadFile((String)path, (InputStream)in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        table.setDatafileDownUrl(backUrl);
        this.tableManager.updateById((Object)table);
        file.setFilePath(backUrl);
        file.setIsCreate("1");
        return this.updateById((Object)file);
    }

    @Override
    public void downloadFile(HttpServletResponse response, HttpServletRequest request, String id) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        BizShareConsumer consumer = (BizShareConsumer)((Object)this.consumerManager.getOne((Wrapper)new LambdaQueryWrapper().eq(BizShareConsumer::getLoginUser, (Object)user.getAccount())));
        BizShareFiles file = (BizShareFiles)((Object)((BizShareFilesDao)this.baseMapper).selectById((Serializable)((Object)id)));
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)file.getTableId()));
        if (!user.isAdmin()) {
            int count = this.authManager.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareAuth::getMemberId, (Object)consumer.getId())).eq(BizShareAuth::getTableId, (Object)table.getId())).eq(BizShareAuth::getResourceId, (Object)file.getId()));
            if (BeanUtils.isEmpty((Object)((Object)consumer)) || count == 0) {
                throw new ApplicationException("\u60a8\u6ca1\u6709\u4e0b\u8f7d\u6743\u9650\uff01");
            }
        }
        this.downloadExcel(file.getFileName(), response);
    }

    @Override
    public List<BizShareFiles> queryByTableId(String tableId) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(BizShareFiles::getTableId, (Object)tableId));
        return list;
    }

    @Override
    public PageList<BizShareFiles> queryPageByCatalog(QueryFilter<BizShareFiles> queryFilter, String catalogId, String consumerId) {
        IPage<BizShareFiles> iPage = ((BizShareFilesDao)this.baseMapper).queryPageByCatalog((IPage<BizShareFiles>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareFiles>)this.convert2Wrapper(queryFilter, this.currentModelClass()), catalogId, consumerId);
        return new PageList(iPage);
    }

    @Override
    public BizShareFiles getInfo(String id) {
        BizShareFiles files = (BizShareFiles)this.get((Serializable)((Object)id));
        SysDataSource dataSource = (SysDataSource)this.dataSourceManager.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getAlias, (Object)files.getDbAlias()));
        if (BeanUtils.isNotEmpty((Object)dataSource)) {
            files.setDatabaseId(dataSource.getId());
        }
        return files;
    }

    @Override
    public boolean removeFilesById(String id) {
        BizShareFiles files = (BizShareFiles)this.get((Serializable)((Object)id));
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)files.getTableId()));
        String path = "dataShare/" + table.getTableCode();
        boolean result = HuaweiyunOssUtil.deleteFile((String)path);
        if (result) {
            return this.removeById((Serializable)((Object)id));
        }
        return false;
    }

    @Override
    public PageList<BizShareFiles> queryPage(QueryFilter<BizShareFiles> queryFilter) {
        PageList pageList = this.query(queryFilter);
        List filesList = pageList.getRows();
        for (BizShareFiles files : filesList) {
            SysDataSource dataSource = (SysDataSource)this.dataSourceManager.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getAlias, (Object)files.getDbAlias()));
            if (!BeanUtils.isNotEmpty((Object)dataSource)) continue;
            files.setDatabaseId(dataSource.getId());
        }
        return pageList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeBatch(List<String> ids) {
        for (String id : ids) {
            this.removeFilesById(id);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadExcel(String fileName, HttpServletResponse response) throws IOException {
        String filedisplay = URLEncoder.encode(fileName + ".xlsx", "utf-8");
        response.setContentType("APPLICATION/OCTET-STREAM");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.addHeader("Content-Disposition", "attachment;filename=" + filedisplay);
        response.addHeader("filename", filedisplay);
        ServletOutputStream out = null;
        String path = "dataShare/" + fileName;
        ByteArrayInputStream input = new ByteArrayInputStream(HuaweiyunOssUtil.Download((String)path, (OutputStream)response.getOutputStream()));
        try {
            int len;
            out = response.getOutputStream();
            byte[] b = new byte[1024];
            while ((len = input.read(b)) != -1) {
                out.write(b, 0, len);
            }
            input.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private boolean check(BizShareFiles file) {
        int count;
        String id = file.getId();
        String fileName = file.getFileName();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareFiles::getFileName, (Object)fileName);
        if (StringUtil.isNotEmpty((String)id)) {
            queryWrapper.ne(BizShareFiles::getId, (Object)id);
        }
        return (count = this.count((Wrapper)queryWrapper)) == 0;
    }
}

