const referDataManager = [
  {
    //  参考数据类--行政区划
    path: 'featuresArithmetic/referDataManager/areaReferDataManager',
    name: 'areaReferDataManager',
    component: () => import('@/views/featuresArithmetic/referDataManager/areaReferDataManager/index.vue'),
  },
  {
    // 参考数据类 - 枚举字典管理
    path: 'featuresArithmetic/referDataManager/enumDicData',
    name: 'enumDicData',
    component: () => import('@/views/featuresArithmetic/referDataManager/enumDicData/index.vue'),
  },
  {
    // 参考数据类 - 多维字典管理
    path: 'featuresArithmetic/referDataManager/multiDicData',
    name: 'multiDicData',
    component: () => import('@/views/dataResource/dataManage/dataDimension/index.vue'),
  },
];
// 人资类
const hrDataManager = [
  {
    // 职务管理
    path: 'featuresArithmetic/hrDataManager/dutyCompany',
    name: 'dutyCompany',
    component: () => import('@/views/featuresArithmetic/hrDataManager/dutyCompany/index.vue'),
  },
  {
    // 岗位管理
    path: 'featuresArithmetic/hrDataManager/positionCompany',
    name: 'positionCompany',
    component: () => import('@/views/featuresArithmetic/hrDataManager/positionCompany/index.vue'),
  },
];
// 公共基础类
const commonBaisc = [
  {
    // 路线信息
    path: 'featuresArithmetic/commonBaisc/commonBasicRoute',
    name: 'commonBasicRoute',
    component: () => import('@/views/featuresArithmetic/commonBaisc/commonBasicRoute/index.vue'),
  },
  {
    // 路段信息
    path: 'featuresArithmetic/commonBaisc/commonBaiscRoad',
    name: 'commonBaiscRoad',
    component: () => import('@/views/featuresArithmetic/commonBaisc/commonBaiscRoad/index.vue'),
  },
  {
    // 开通路段
    path: 'featuresArithmetic/commonBaisc/commonBaiscMark',
    name: 'commonBaiscMark',
    component: () => import('@/views/featuresArithmetic/commonBaisc/commonBaiscMark/index.vue'),
  },
];
// 结构物类
const structureMdm = [
  {
    // 桥梁信息
    path: 'featuresArithmetic/structureMdm/structureMdmBridge',
    name: 'structureMdmBridge',
    component: () => import('@/views/featuresArithmetic/structureMdm/structureMdmBridge/index.vue'),
  },
  {
    // 隧道信息
    path: 'featuresArithmetic/structureMdm/structureMdmTunnel',
    name: 'structureMdmTunnel',
    component: () => import('@/views/featuresArithmetic/structureMdm/structureMdmTunnel/index.vue'),
  },
  {
    // 边坡信息
    path: 'featuresArithmetic/structureMdm/structureMdmSlope',
    name: 'structureMdmSlope',
    component: () => import('@/views/featuresArithmetic/structureMdm/structureMdmSlope/index.vue'),
  },
  {
    // 涵洞信息
    path: 'featuresArithmetic/structureMdm/structureMdmCulvert',
    name: 'structureMdmCulvert',
    component: () => import('@/views/featuresArithmetic/structureMdm/structureMdmCulvert/index.vue'),
  },
];
export default [
  /* 参考数据类 */
  ...referDataManager,
  ...hrDataManager,
  ...commonBaisc,
  ...structureMdm,
];
