import req from '@/request.js';

const bpmModel = window.context.bpmModel;
const bpmRunTime = window.context.bpmRunTime;
const portal = window.context.portal;

export default {
  // ods每日采集任务日志
  getHistroyByDay(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/scheduler/collect/day/v1/query`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },
  // ods采集任务明细列表
  getHistroyByTime(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/scheduler/collect/times/v1/query`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },

  // ods采集任务明细数据
  getTableData(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/odsTable/v1/queryTableData`, data).then(
        (response) => {
          resolve(response.data);
        },
        (error) => {
          reject(error);
        },
      );
    });
  },
};
