import req from '@/request.js'

const headersUrlencoded = {
  Accept: 'application/json;charset=utf-8',
  'Content-type': 'multipart/form-data'
}
const portal = window.context.portal
export default {
  // 移动表
  MoveData(queryParams, formData) {
    return new Promise((resolve, reject) => {
      // 拼接完整URL（查询参数）
      const url = `${portal}/biz/dataResource/dwTable/v1/updateCatalog?${queryParams}`

      req.put(url, formData, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(
        response => {
          if (response?.data?.state) {
            resolve(response.data)
          } else {
            reject(response?.data?.message || '操作失败')
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取DW资源目录下拉树
  getDWTree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwCatalogs/v1/getTree`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 新增DW资源目录
  addDWTree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwCatalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 编辑DW资源目录
  editDWTree(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/dataResource/dwCatalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 删除DW资源目录
  removeDWTree(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/dataResource/dwCatalogs/v1/${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 获取DW资源项
  queryDWTable(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 新增DW资源项
  addDWSource(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 获取DW资源项
  editDWSource(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/dataResource/dwTable/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 删除DW资源项
  removeDWSource(id) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/removeTable?tableId=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 发布DW资源项
  publishDWSource(id) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/Deploy?tableId=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 查询字段
  queryFieldsByTableId(id) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/queryTableVo?tableId=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 保存字段
  saveFields(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwField/v1/saveOrUpdates`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  saveOrUpdateFields(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwField/v1/saveOrUpdateFields`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 字段删除
  deleteField(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/dataResource/dwField/v1/${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 物理表 数据查询
  queryWLTableData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/queryTableData`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 物理表 数据查询
  queryDTTableData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataResource/dwTable/v1/queryDTTableData`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 数据治理日志
  dataGovernanceLog(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dwddata/cleanlogs/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 数据上传模版下载
  downloadDataModel(tableId) {
    return new Promise((resolve, reject) => {
      req
        .downloadPostCopy(`${portal}/biz/dataResource/dwTable/v1/downloadMainTempFile/${tableId}`)
        .then((res) => resolve(res?.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 建物理表语句
  physicalTable(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/dwTable/v1/queryTableSql/${tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 建动态表语句
  dynamicTable(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/dwTable/v1/queryDtTableSql/${tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 验证
  checkSurfaceCh(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataResource/dwTable/v1/checkPhysicsTableExists?tableNameEn=${data.tableNameEn}&type=${data.type}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 未有表发布
  unpublishedTable(data) {
    const param = {
      url: `${portal}/biz/dataResource/dwTable/v1/deployDotHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 已有表发布
  existingTablePublishing(data) {
    const param = {
      url: `${portal}/biz/dataResource/dwTable/v1/deployHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  }
}
