import req from '@/request.js'

const portal = window.context.portal
export default {
  // 移动表
  MoveData(queryParams, formData) {
    return new Promise((resolve, reject) => {
      // 拼接完整URL（查询参数）
      const url = `${portal}/biz/dataShare/shareTable/v1/updateCatalog?${queryParams}`

      req.put(url, formData, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(
        response => {
          if (response?.data?.state) {
            resolve(response.data)
          } else {
            reject(response?.data?.message || '操作失败')
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 树接口
  getShareTree(data) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/dataShare/shareCatalogs/v1/getTree`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增树接口
  addShareTree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataShare/shareCatalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 编辑资源目录
  editShareTree(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/dataShare/shareCatalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 删除资源目录
  removeShareTree(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/dataShare/shareCatalogs/v1/${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 分页查询-列表
  shareCatalogsTable(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/query`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 新增
  demandSideAdd(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 修改
  demandSideEdit(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataShare/shareTable/v1/`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 查询详情
  getCompanyDetail(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/queryTableInfo`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 批量删除
  deleteTableData(data) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareTable/v1/removeTableBatch?ids=${data}`).then(
        response => {
          resolve(response.data || {})
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 单个删除
  removeShare(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareTable/v1/removeTable/${id}`).then(
        (res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  getFieldsList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/queryTableField`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  saveFields(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTableField/v1/saveInfoBatch`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 发布后更新字段
  saveOrUpdateFields(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTableField/v1/saveOrUpdateFields`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 新增验证表英文名
  checkSurfaceName(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/checkTableExists`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 建表语句
  gainTableSql(tableId) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/dataShare/shareTable/v1/queryTableSql?id=${tableId}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 验证
  checkSurfaceCh(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/checkPhysicsTableExists`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 未有表发布
  unpublishedTable(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/deployDotHaveTable`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 已有表发布
  existingTablePublishing(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareTable/v1/deployHaveTable`, data).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 文件资源列表
  fileResourceList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareFiles/v1/query`, data).then(
        response => {
          resolve(response.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 新增文件
  fileAddTable(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataShare/shareFiles/v1/saveInfo`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 编辑文件
  fileEditTable(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/dataShare/shareFiles/v1/updateInfo`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 下载
  fileUpload(id) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/dataShare/shareFiles/v1/downloadFile?id=${id}`).then(
        (res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 生成文件
  spannedFile(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataShare/shareFiles/v1/uploadFile`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 资源列表-文件列表-单个删除
  fileRemoveDelete(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareFiles/v1/${id}`).then(
        (res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 资源列表-文件列表-批量删除
  fileRemoveTableDelete(data) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareFiles/v1/removeBatch?ids=${data}`, data).then(
        response => {
          resolve(response.data || {})
        },
        error => {
          reject(error)
        }
      )
    })
  }

}
