import req from '@/request.js'

const portal = window.context.portal
export default {
  // 分页列表
  apiList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareApi/v1/query`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-新增-数据源数据
  addSourceData() {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/datasourcesRelation/v1/queryList/4`).then(
        (response) => {
          resolve(response)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-新增接口
  addAction(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareApi/v1/register`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // table列表-删除按钮接口
  delApiData(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataShare/shareApi/v1/unregister?id=${id}`).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-发布
  // updateAction(data) {
  //   return new Promise((resolve, reject) => {
  //     req.put(`${portal}/biz/dataShare/shareApi/v1/updateServiceApi`, data).then(
  //       (response) => {
  //         resolve(response.data)
  //       },
  //       (error) => {
  //         reject(error)
  //       }
  //     )
  //   })
  // },
  //发布接口
  publishAPI(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataShare/shareApi/v1/publish`, data, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded' // 确保后端能正确解析 FormData
        }
      }).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  //下架接口
  TakeoffAPI(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataShare/shareApi/v1/soldOut`, data, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded' // 确保后端能正确解析 FormData
        }
      }).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 按钮-接口文档查看
  interfaceData(id) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/dataShare/shareApi/v1/viewApiDocument/${id}`).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-按钮-接口日志
  apiLog(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataShare/shareApiLog/v1/query`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-编辑接口
  delActions(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataShare/shareApi/v1/updateServiceApi`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  }
}
