[Table of Contents](index.md)

* [Usage](1.usage.md)
* [Options *](2.options.md)
* [Operation](3.operation.md)
* [Experimental Features](experimental-features.md)
  * [Screenshot (Export as Image)](plugin-screenshot.md)
* [Contribution](4.contribution.md)
* [Development Guide](5.development.md)


2.1. Introduction
===

The options object for jsMind was briefly mentioned in the example in the previous chapter:

```javascript
var options = {
    container:'jsmind_container', 	// [required] ID of the container
    editable:true, 					// [Optional] Whether to enable editing
    theme:'orange' 					// [optional] theme
};
var jm = new jsMind(options);
````

But that's only a small part of it, and the full definition of the options object for jsMind is shown below:

```javascript
options = {
   container : '', 			// [required] ID of the container
   editable : false, 		// Is editing enabled?
   theme : null, 			// theme
   mode :'full', 			// display mode
   support_html : true, 	// Does it support HTML elements in the node?
   view:{
       engine: 'canvas', 	// engine for drawing lines between nodes in the mindmap
       hmargin:100, 		// Minimum horizontal distance of the mindmap from the outer frame of the container
       vmargin:50, 			// Minimum vertical distance of the mindmap from the outer frame of the container
       line_width:2, 		// thickness of the mindmap line
       line_color:'#555', 	// Thought mindmap line color
       line_style:'curved', // line style, straight or curved
       custom_line_render: null,  // customized line render function
       draggable: false,    // Drag the mind map with your mouse, when it's larger that the container
       hide_scrollbars_when_draggable: false, // Hide container scrollbars, when mind map is larger than container and draggable option is true.
       node_overflow: 'hidden' // Text overflow style in node
   },
   layout:{
       hspace:30, 			// Horizontal spacing between nodes
       vspace:20, 			// Vertical spacing between nodes
       pspace:13,			// Horizontal spacing between node and connection line (to place node expander)
       cousin_space:0			// Additional vertical spacing between child nodes of neighbor nodes
   }, 
   shortcut:{
       enable:true, 		// whether to enable shortcut
       handles:{}, 			// Named shortcut key event processor
       mapping:{ 			// shortcut key mapping
           addchild : [45, 4096+13], 	// <Insert>, <Ctrl> + <Enter>
           addbrother : 13, // <Enter>
           editnode : 113, 	// <F2>
           delnode : 46, 	// <Delete>
           toggle : 32, 	// <Space>
           left : 37, 		// <Left>
           up : 38, 		// <Up>
           right : 39, 		// <Right>
           down : 40, 		// <Down>
       }
   },
};
```

The above options are the default options for jsMind and you can add the appropriate options to override these default options.

Except the container, there are all optional.

These options are described in more detail below.

2.2 Conventional Options
===

**container** : (string) [required] ID of the container

> This parameter is not default when instantiating a jsMind. jsMind uses this parameter to find a page element and output a mindmap to that element. For easy control of the size and position of the mind map, use [block element][1] as a container for the mind map, such as `<div>`.

> You can give the element retouching, but generally limited to setting its size, position, border, etc.; if you want to change the font, font size, background color, foreground color, etc. of the mindmap, it is recommended to add custom themes by way of processing.

**editable** : (bool) Enable editing or not

> If this parameter is set to true, you can use the API to do the above operations, otherwise the API will not take effect. By default, the value of this parameter is false .

> Note that jsMind only provides an editing interface and a small amount of shortcut key support, not full editing functionality, and this parameter is only used to limit the use of these APIs.

**theme** : (string) subject

> Specify the theme name of jsMind. (look in jsMind.css)

**mode** : (string) layout mode

> When adding a first-level child node to the mind map, jsMind will decide which side to place the node based on this option. 2 layout modes are currently supported:

> * `full` - child nodes are dynamically distributed on both sides of the root node [default]
> * `side` - child nodes are distributed only to the right of the root node

> Note that this option only takes effect when adding nodes (`jsMind.add_node(...)`)

**support_html** : (bool) Does it support HTML elements in nodes?

> The default value of this parameter is true, meaning that it allows HTML code to be used in the node's header, and you can even insert a table `<table>` in the node's header if you wish. If you want only plain text in the title, set this parameter to false .

> Note that in freemind, the style of the node is controlled using the HTML language, and it is recommended to set this parameter to true if you are using data in freemind format.

**log_level** : (string) log level

> There are 5 levels: `debug`/`info`/`warn`/`error`/`disable`, default level is `info`. if it set to `disable`, all the logs will be closed.

2.3 Layout Options
===

**view.engine** : (string) engine for drawing lines between nodes in a mindmap

> jsMind now supports two line drawing engines:

> * `canvas` - Draw the lines on the canvas [default]
> * `svg` - Using SVG to draw lines, when there are a lot of nodes and a huge area in the mind map, using this mode can bring significant performance improvements

**view.enable_device_pixel_ratio** : (bool) draw HD mindmap according to the device pixel ratio. (since 0.8.5)

> This parameter is only used to improve the mindmap resolution when `view.engine=canvas`. It does not need to be set when the engine is `svg`.

**view.hmargin** : (number) Minimum horizontal distance (in pixels) of the mindmap from the container frame  
**view.vmargin** : (number) Minimum vertical distance (in pixels) of the mindmap from the outer container frame

> These two parameters determine how close the mindmap can be to the border of the container. These two parameters are similar to the margin(css) property of the object if you consider the thought map itself as an object. The default value of them are the width and height of the container.

**view.line_width** : (number) Thickness of the mindmap line (pixels)  
**view.line_color** : (string) color of the mindmap line (color representation in HTML). If `data.leading-line-color` is set on `node`, this option will be overridden.
> By default, the lines are 2px in thickness and dark gray in color (#555).

**view.line_style** : (string) style of the mindmap line. The available options are:
> * `curved` [default]
> * `straight`

**view.custom_line_render** : (function) customize the line render function

> * method signature: `function custom_line_render({ctx, start_point: {x, y}, end_point: {x, y}}):void`
> * `this` presents [current line renderer](https://github.com/hizzgdev/jsmind/blob/master/src/jsmind.graph.js)，`ctx` is a canvas context object or a SVG path DOM object, which is determined by `view.engine`, `start_point` and `end_point` are two coordinates object, contains `x` and `y` properties.
> * Note: if you want use [`this`](https://github.com/hizzgdev/jsmind/blob/master/src/jsmind.graph.js) object, you should NOT use Arrow Function expressions.

**view.draggable** : (bool) Do you want whole mind map draggable inside container?

> The default value of this parameter is false, as it keep the default behavior with vertical and horizontal scrollbars on the container when mind map is bigger than the container.

**view.hide_scrollbars_when_draggable** : (bool) Do you want to hide container scrollbars?

> Rely on draggable option activation, as otherwise it wouldn't be possible to explore the whole mind map when it's bigger than the container.
> The default value of this parameter is false, as it keep the default behavior with vertical and horizontal scrollbars on the container when mind map is bigger than the container.
> Otherwise, if true, there is no more scrollbars, and instead you can drag the mind map with your mouse, while button is down. It should be noted that in this case, the user will not be able to explore the mind map by rolling the mouse wheel.

**view.node_overflow** : (string) Text overflow style in node (since 0.5.3)

> 2 styles are currently supported when the node text is too long

> * `hidden` - Hide part of them to maintain the overall readability of the mind map [default]
> * `wrap` - Wrap the text to display the entire content

**view.zoom** : (object) zoom setting (since 0.6.3)
> * min -  minimum zoom ratio，default 0.5
> * max - maximum zoom ratio, default 2.1
> * step - interval of zoom ratio, default 0.1

**view.custom_node_render** : (function) custom rendering method for node (since 0.7.6)

> The option can be used to change the default rendering logic of jsMind. The value of this option is a function, whose signature is `function (jm, element, node): boolean`. Its return value is used to indicate whether the node has been rendered. If it returns `true`, jsMind won't render the node again, otherwise, jsMind will render the node in the default way.

**view.expander_style** : (string) style of the node expander (since 0.7.8)

> * `char` - show `-`, `+` in the expander to represent the expanded status [default]
> * `number` - show the count of children node in the expander, when the count of children more than 99, show `...` instead

**layout.hspace** : horizontal distance (pixels) between (number) nodes  
**layout.vspace** : vertical spacing (pixels) between (number) nodes

> These two parameters are equivalent to the margin(css) property of the node object, which defaults to 30 pixels in the horizontal direction and 20 pixels in the vertical direction.

**layout.pspace** : (number) size of node expander (pixels)

> If a node (other than the root node) has a subordinate node, the outside of this node shows the controller for the shrinking/expanding subordinate node, which is used to set the size (width and height) of this controller, the default value is 13 pixels.

**layout.cousin_space** : (number) additional vertical spacing (pixels) between child nodes of neighbor nodes (since 0.5.5)

> The default value is 0, which means no additional vertical spacing

2.4. Shortcuts
===

**shortcut.enable** : (bool) Whether to enable shortcut keys

> This parameter is used to control whether you can use keyboard shortcuts to edit (or otherwise manipulate) a mindmap in the jsMind interface, the default value is true, i.e. shortcuts are enabled.

**shortcut.handles** : (object{string : function}) Named shortcut event handler

> jsMind provides some common event handler for manipulating mindmaps (see next section), and this parameter provides the ability to define additional event handler.
> This parameter is a collection of string->function(jsmind,event), string specifies the name of the event handler, and function is the logic to be executed by the event handler, in the next section of shortcut.mapping configuration, the name of the processor will be bound to the specific keys for the purpose of shortcut operation. For example, the following code defines a processor.

```javascript
handles : {
    'dosomething' : function(jm,e){
        // do something...
    },
    'dosomeotherthing' : function(jm,e){
        // do some other things
    }
    ...
}
```

**shortcut.mapping** : (object{string : number | [number]}) Shortcut mapping configuration

> This parameter is used to configure the correspondence between a specific key and the event handler, this code shows the correspondence by default, e.g. the code for the [Insert] key is 45 and can be used to add a child node, while 112 represents the [F1] key for dosomething.
> Note: You can also bind multiple shortcut keys to an event handler, just use an array.

```javascript
mapping:{                       // handle mapping.
   addchild   : [45, 4096+13],  // <Insert>, <Ctrl> + <Enter>
   addbrother : 13,             // <Enter>
   editnode   : 113,            // <F2>
   delnode    : 46,             // <Delete>
   toggle     : 32,             // <Space>
   left       : 37,             // <Left>
   up         : 38,             // <Up>
   right      : 39,             // <Right>
   down       : 40,             // <Down>

   // Examples
   dosomething: 112,            // <F1>
}
```

> In addition to the single-key scenario described above, jsMind has added support for combination keys, where the code of the combination shortcut is the code of the regular key plus the identification code of the function key.
> Four function keys are currently supported, and the corresponding identification codes are.

> * Meta : 8192
> * Ctrl : 4096
> * ALT : 2048
> * SHIFT : 1024

> The following are some examples.

```javascript
mapping:{
   addchild : 4096 + 73,        // <Ctrl> + <I>
   delnode : 4096 + 2048 + 68,  // <Ctrl> + <ALT> + <D>
}
```

copyright notice
===

Reproduction and deduction are prohibited.

The jsMind project is still being updated and the corresponding documentation is updated at the same time as the version is updated. In order to avoid confusion to the user, it is forbidden to reprint this document without written permission and to make changes of any kind to this document.

[1]:http://www.nowamagic.net/librarys/veda/detail/1190 "CSS Block Level Element, Inline Element Concept"
