import { SelectVersionEnum, PanelTypeEnum, VisibilityCodesEnum } from './chooseContact';
export interface ContactComplexPickerParams {
    title?: string;
    limitTips?: string;
    multiple?: boolean;
    maxUsers?: number;
    pickedUsers?: string[];
    disabledUsers?: string[];
    requiredUsers?: string[];
    disabledDepartments?: string[];
    pickedDepartments?: string[];
    requiredDepartments?: string[];
    responseUserOnly?: boolean;
    selectVersion?: SelectVersionEnum;
    panelTypes?: PanelTypeEnum[];
    visibilityCodes?: VisibilityCodesEnum;
    enableExternalUser?: boolean;
    organizationToPerson?: boolean;
}
export interface DepartmentModel {
    id: string;
    name: string;
}
export interface UserModel {
    name: string;
    avatar?: string;
    userid: string;
}
export interface ContactComplexPickerResult {
    selectedCount: number;
    users: UserModel[];
    departments: DepartmentModel[];
}
declare function chooseContactWithComplexPicker(params: ContactComplexPickerParams): Promise<ContactComplexPickerResult>;
declare namespace chooseContactWithComplexPicker {
    var version: {
        android: string;
        ios: string;
        pc: string;
    };
}
export default chooseContactWithComplexPicker;
