import req from '@/request.js'

const portal = window.context.portal
export default {
  // 新增勤务岗位信息
  addCmgtDutyJob(data, cb) {
    req.post(portal + `/manager/cmgtDutyGrid/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改勤务岗位信息
  editCmgtDutyJob(data, cb) {
    req.put(portal + `/manager/cmgtDutyGrid/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询勤务岗位信息
  loadCmgtDutyJob(data, cb) {
    req.post(portal + `/manager/cmgtDutyGrid/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除勤务岗位信息
  deleteCmgtDutyJob(data, cb) {
    req.remove(portal + `/manager/cmgtDutyGrid/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询勤务岗位信息
  getCmgtDutyJobByID(id, cb) {
    req.get(portal + `/manager/cmgtDutyGrid/` + id).then(res => {
      cb(res.data)
    })
  },
  // 根据岗位id查询人员经纬度
  getCmgtDutyUserLatByID(data, cb) {
    req.get(portal + `/manager/cmgtDutyTeamMemberGpsinfo/queryTeamMemberTrack/?` + data).then(res => {
      cb(res.data)
    })
  },
  // 根据岗位查询人员情况
  getStatisticsTeamMemberTrack(id, cb) {
    req.get(portal + `/manager/cmgtDutyTeamMemberGpsinfo/statisticsTeamMemberTrack/?jobId=` + id).then(res => {
      cb(res.data)
    })
  },
  // 根据人员id查询区域
  getAreaCodeByPersonId(id, cb) {
    req.get(portal + `/manager/duty/member/getJobId/?id=` + id).then(res => {
      cb(res.data)
    })
  },
  // 分页查询设备绑定队员信息
  loadDeviceBoundPlayer(data, cb) {
    req.post(portal + `/manager/duty/member/queryDeviceMemberPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 给队员绑定/解绑设备 /manager/duty/member/updateDeviceCodeId
  deviceBindingUnbinding(data, cb) {
    const {memberId, deviceCode} = data
    req.get(portal + `/manager/duty/member/updateDeviceCodeId?memberId=${memberId}&deviceCode=${deviceCode}`).then(res => {
      cb(res.data)
    })
  }

}
