# **My-Tree树形组件文档**

## *prop参数

| 参数                 | 说明                                                                                                                                                                                                                                              | 类型      | 默认值                                                                                                                                                                                 |
|--------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| tree               | *树形数据源*                                                                                                                                                                                                                                         | Array   | [ ]                                                                                                                                                                                 |
| son-options        | *多项子集配置*，可有多组对象配置<br />childrenkey        树形子集键名  （默认值为children）  <br />nameKey           显示名称键名（默认值为name）<br       />idKey                 唯一标识符键名（默认值为id）<br />disabledKey       是否禁用键名（默认值disabled）<br />height                 行高度（默认值40px） | Array   | [{  <br />   'childrenkey': 'children',<br />   'nameKey': 'name',<br />   'idKey': 'id',<br />   'disabledKey': 'disabled',<br />   'height': '40px'<br />}]                       |
| top-child          | *顶层对象含义*                                                                                                                                                                                                                                        | String  | 'children'                                                                                                                                                                          |
| tree-params        | *个性化样式配置*<br />                                                                                                                                                                                                                                 | Object  | {  <br />   'prefixIcon': 'children',       *前置图标*<br />   'postIcon': 'name',     *后置图标（自动旋转）*<br />   'disabledIcon': 'id',       *禁用图标*<br />   'border': false,     是否边框<br />} |
| indent             | *相邻级节点间的水平缩进，单位为像素*                                                                                                                                                                                                                             | Number  | 18                                                                                                                                                                                  |
| default-expand-all | *是否默认展开所有节点*                                                                                                                                                                                                                                    | Boolean | false                                                                                                                                                                               |
| fold-all           | *折叠时关闭所有已经打开的子集，再次打开时需要一级一级打开*                                                                                                                                                                                                                  | Boolean | false                                                                                                                                                                               |
| open-serch         | *开启本地搜索*                                                                                                                                                                                                                                        | Boolean | false                                                                                                                                                                               |
| tree-style         | *自定义样式类名*                                                                                                                                                                                                                                       | String  | ' '                                                                                                                                                                                 |

## *Events事件

| 事件名称                  | 说明      | 回调参数       |
|-----------------------|---------|------------|
| *tree-item-click*     | *底层行点击* | 当前行对象参数    |
| *disabled-item-click* | 禁用行点击   | 当前行对象参数    |
| *is-finished*         | 数据加载完执行 | 参数为扁平化数据结构 |

## *Methods方法

可通过子组件dom元素调用

| 方法名       | 说明         | 参数 |
|-----------|------------|----|
| expandAll | *展开整个树形结构* | —— |

## *Slots插槽

| name      | 说明                        |
|-----------|---------------------------|
| ———       | 自定义整行内容 参数为 { row }       |
| *prefix*  | 自定义前置图标区域的内容  参数为 { row } |
| *content* | 自定义文本区域的内容  参数为 { row }   |
| *post*    | 自定义后置图标区域的内容  参数为 { row } |

##   
