import req from '@/request.js'
const portal = window.context.portal
export default {
  // 查询物资信息
  materialInfoQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/materialinfo/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
    // 查询物资信息
  materialInfoPageQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/quantity/pageQuery`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增物资信息
  addMaterialInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/materialinfo/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 更新物资信息
  updateMaterialInfo(data) {
    return new Promise((resolve, reject) => {
      req.put(portal + `/manager/material/materialinfo/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据id查询物资信息
  materialInfoDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/manager/material/materialinfo/` + id).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 批量删除物资信息
  removeMaterialInfos(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/manager/material/materialinfo/`, ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
    // 批量修改排序号
  updateSequenceClass(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/materialinfo/updateSequence`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
          materialinfoExport(data, cb) {//集团产能分布情况数据导出
        req.post(portal + `/manager/material/materialinfo/export`, data,'blob').then(res => {
            cb(res.data)
        })
    },
  // 查询分类树
  loadAllClass(data, cb) {
    req.get(portal + `/manager/material/class/findAll`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增分类
  addClass(data, cb) {
    req.post(portal + `/manager/material/class/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改分类
  editClass(data, cb) {
    req.put(portal + `/manager/material/class/`, data).then(res => {
      cb(res.data)
    })
  },
  // 删除分类
  deleteClass(data, cb) {
    req.remove(portal + `/manager/material/class/`+data).then(res => {
      cb(res.data)
    })
  },
  getMaterialCode(cb){
	  req.get(portal+'/sys/identity/v1/getNextIdByAlias?alias=lsh').then(res =>{
		  cb(res.data)
	  })
  },
  // 根据id查询分类
  getClassByID(id, cb) {
    req.get(portal + `/manager/material/class/` + id).then(res => {
      cb(res.data)
    })
  },
}
