import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增小组信息
  addTeam(data, cb) {
    req.post(portal + `/manager/duty/team/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改小组信息
  editTeam(data, cb) {
    req.put(portal + `/manager/duty/team/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询小组信息
  loadTeam(data, cb) {
    req.post(portal + `/manager/duty/team/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除小组信息
  deleteTeam(data, cb) {
    req.remove(portal + `/manager/duty/team/`, data).then(res => {
      cb(res.data)
    })
  },
}