import req from '@/request.js'

const portal = window.context.portal
const headers = {
  'Content-type': 'application/x-www-form-urlencoded',
}

export default {
  //点击树获取分页
  getList(data, cb) {
    req
      .post(portal + `/biz/catalog/videoImport/v1/queryPage`, data)
      .then((rep) => {
        cb(rep.data)
      })
  },
  //区域树
  getTree(data, cb) {
    req.post(portal + `/biz/catalog/base/getTree`, data).then((rep) => {
      cb(rep.data)
    })
  },
  updatePoint(data) {
    return new Promise((resolve, reject) => {
      req.put(portal + `/biz/catalog/videoImport/v1/`, data).then((rep) => {
        resolve(rep.data)
      })
    })
  },
  updatePosition(data) {
    return new Promise((resolve, reject) => {
      req
        .request({
          method: 'post',
          url: portal + '/biz/catalog/videoImport/v1/updatePosition',
          data,
          headers,
        })
        .then((res) => {
          resolve(res.data)
        })
    })
  },
  // 根据id批量删除
  deleteByIds(ids) {
    return new Promise((resolve, reject) => {
      req
        .request({
          method: 'delete',
          url: portal + `/biz/catalog/videoImport/v1/?ids=${ids}`,
          headers,
        })
        .then((res) => {
          resolve(res.data)
        })
    })
  },
}
