import req from '@/request.js'

const portal = window.context.portal
export default {
  // 新增单位
  addUnit(data, cb) {
    req.post(portal + `/device/base/company/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改单位
  editUnit(data, cb) {
    req.put(portal + `/device/base/company/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询单位
  loadUnit(data, cb) {
    req.post(portal + `/device/base/company/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除单位
  deleteUnit(data, cb) {
    req.remove(portal + `/device/base/company/`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增区域
  addArea(data, cb) {
    req.post(portal + `/device/baseArea/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改区域
  editArea(data, cb) {
    req.put(portal + `/device/baseArea/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询区域
  loadArea(data, cb) {
    req.post(portal + `/device/baseArea/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 查询区域下拉树
  loadAreaTree(data, cb) {
    req.post(portal + `/device/baseArea/getTree`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除区域
  deleteArea(data, cb) {
    req.remove(portal + `/device/baseArea/`, data).then(res => {
      cb(res.data)
    })
  },
  // 查询行政区划下拉树
  loadAdminAreaTree(data, cb) {
    req.post(portal + `/sys/sysAreas/v1/townTree`, data).then(res => {
      cb(res.data)
    })
  },
  // 查询产品 不分页
  loadProduct(data, cb) {
    req.post(portal + `/device/product/info/findAll`, data).then(res => {
      cb(res.data)
    })
  },
  //级联产品
  getProductTree(data, cb) {
    req.post(portal + `/device/product/type/getProductTree`, data).then(res => {
      cb(res?.data || [])
    })
  },
  // 查询设备
  loadDevice(data, cb) {
    req.post(portal + `/device/info/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增设备
  addDevice(data, cb) {
    req.post(portal + `/device/info/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改设备
  editDevice(data, cb) {
    req.put(portal + `/device/info/`, data).then(res => {
      cb(res.data)
    })
  },
  // 删除设备
  deleteDevice(data, cb) {
    req.remove(portal + `/device/info/`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增设备扩展信息
  addExtend(data, cb) {
    req.post(portal + `/device/params/conf/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改设备扩展信息
  editExtend(data, cb) {
    req.put(portal + `/device/params/conf/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询设备扩展信息
  loadExtend(data, cb) {
    req.post(portal + `/device/params/conf/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除设备扩展信息
  deleteExtend(data, cb) {
    req.remove(portal + `/device/params/conf/`, data).then(res => {
      cb(res.data)
    })
  },
  //导出接口配置，注意后面blob
  infoExportExcel(data, cb) {
    req.post(portal + `/device/info/exportExcel`, data, 'blob').then(res => {
      cb(res.data)
    })
  },
  //保存排序
  saveProperty(data, cb) {
    req.post(portal + `/device/params/conf/updateSequence`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 预警信息列表
  getForewarningData(data, cb) {
    req.post(portal + `/device/warnInfo/recentWarnInfo`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 设备类型统计数据
  deviceProductStatistics(cb) {
    req.post(portal + `/homepage/v1/deviceProductStatistics`).then(res => {
      cb(res.data)
    })
  },
  //设备总数统计
  getTotalityData(cb) {
    req.post(portal + `/device/info/count/deviceParent`).then(res => {
      cb(res.data)
    })
  },
  getFilterTree(data, cb) {
    req.post(portal + `/device/product/type/filterTree`, data).then(res => {
      cb(res?.data || [])
    })
  },
  // 摄像头查询
  loadCameraDevice(data, cb) {
    req.post(portal + `/biz/catalog/base/point/queryPointPage`, data).then(res => {
      cb(res?.data || [])
    })
  },
  // 统计数据列表查询
  countTableData(code, queryParams, cb) {
    req.post(portal + `/device/info/deviceDetails?code=${code}`, queryParams).then(res => {
      cb(res?.data || [])
    })
  }

}
