import req from '@/request'

const portal = window.context.portal


// 获取表格数据
export function tableData(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/query`, data, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取设备产品分类列表
export function getProductTree(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/product/type/getProductTree`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取设备列表(不分页)
export function productTable(productId = '') {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/info/query`, {
      pageBean: { pageSize: -1 }, params: { productId }
    })
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取设备列表(分页)
export function productTableSome(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/info/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取人员列表不分页
export function orgUserQuery(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/user/v1/users/getOrgUserQuery`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增巡检计划
export function deviceInspectionPlanAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/add`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 巡检计划详情
export function deviceInspectionPlanDetails(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionPlan/v1/details?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改巡检计划
export function deviceInspectionPlanEdit(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/edit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除巡检计划
export function removePlan(ids) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/remove?ids=${ids}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增或修改巡检计划
export function addOrUpdatePlan(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/saveOrUpdateInfo`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 巡检计划详情
export function getPlanDetailsById(id = '') {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/detail?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

export function getPlanDetailsListById(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlanDetails/v1/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 计划分发 
export function planDistribute(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/confirmDistribution?planId=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 计划分发撤回
export function planRetract(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/confirmWithdrawal?planId=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 计划修改派遣人
export function planUpdatePerson(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/deviceInspectionPlanDetails/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}


// 删除巡检计划
export function removePlanById(ids) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlan/v1/removeByIds?ids=${ids}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除巡检计划中的产品
export function removeProductById(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionPlanDetails/v1/removeProductById?productId=${id}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}


// 删除巡检计划中的设备
export function deleteEquipment(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/deviceInspectionPlanDetails/v1/?ids=${ids}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 巡查任务列表查询
export function taskTableData(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionTask/v1/queryPage`, data, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 任务详情查询 
export function getTaskDetailsById(id = '') {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionTask/v1/detail?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 任务修改派遣人
export function taskUpdatePerson(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/deviceInspectionTaskDetails/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 任务删除巡检计划中的设备
export function taskDeleteEquipment(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/deviceInspectionTaskDetails/v1/?ids=${ids}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 接收任务
export function receivingTask({ id, status }) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionTask/v1/updateById?id=${id}&status=${status}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 任务详情设备列表查询
export function getPCTaskDetailsById(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionTaskDetails/v1/queryPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 部门列表查询
export function getUnitOptions() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/manager/cmgtDutyOrgWorkarrange/findAllOrg`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 巡查结果录入
export function resultEnter(data, cb) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/saveOrUpdateInfo`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 结果详情查询
export function getResultDetails(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionResult/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 图片删除
export function deleteImg(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/file/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 事件上报
export function eventReporting(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/eventBack?resultId=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 查询事件处理结果详细
export function getEventDetails(id) {
  return new Promise((resolve, reject) => {
    req.get(`http://10.23.193.248:9001/event-back/openApi/api/common/getEventInfo?warningId=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}