import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 获取巡检设备入口列表（巡检台账）
export function inspectionPlanTable(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/findByPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 根据巡检计划ID获取设备列表
export function equipmentTable(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/normalInspectionById`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取设备列表(不分页)
export function deviceTable(productId = '') {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/info/query`, {
      pageBean: {pageSize: -1}, params: {productId}
    })
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取设备产品分类列表
export function getProductTree(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/product/type/getProductTree`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 报事报修
export function faultWorkOrder(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/pushData?id=${id}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// (不分页)部门树
export function getByParentAndDemToTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/manager/cmgtDutyOrgWorkarrange/findAllOrgTree`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取设备详情
export function deviceDetails(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionResult/v1/normalDetails?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 登记巡查设备信息
export function registerEquipment(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/inspectionEdit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增巡检设备弹层
export function equipmentAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/add`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}











