import req from "@/request.js";

const portal = window.context.portal;
export default {
	// 查询设备
	query(data, cb) {
	    req.post(portal + `/device/info/query`, data).then(rep => {
	        cb(rep.data);
	    });
	},
	//人员信息查询 
	userQuery(data, cb) {
	    req.post(portal + `/device/base/user/query`, data).then(rep => {
	        cb(rep.data);
	    });
	},
	// 分页查询区域
	loadArea(data, cb) {
	  req.post(portal + `/device/baseArea/query`, data).then(res => {
	    cb(res.data)
	  })
	},
	// 查询行政区划下拉树
	loadAdminAreaTree(data, cb) {
	  req.post(portal + `/sys/sysAreas/v1/townTree`, data).then(res => {
	    cb(res.data)
	  })
	},
	// 根据id查询设备信息
	deviceDetails(id, cb) {
	  req.get(portal + '/device/info/' + id).then(res => {
	    cb(res.data)
	  })
	},
	// 获取设备扩展参数配置
	getExtendParams(data, cb) {
	  req.post(portal + '/device/params/conf/findAll', data).then(rep => {
	    if (rep.data) {
	      cb(rep.data)
	    }
	  })
	},
	// 获取产品扩展参数配置
	getProductParams(data, cb) {
	  req.post(portal + '/device/product/paramsConf/findAll', data).then(rep => {
	    if (rep.data) {
	      cb(rep.data)
	    }
	  })
	},
}