import req from '@/request.js'
const portal = window.context.portal
export default {
  // /* 考核情况 */
  //分页查询
  loadAppraiseInfo(data, cb) {
    req.post(portal + `/device/appraiseInfo/query`, data).then(res => {
      res && cb(res.data)
    })
  },
  // 新增
  addInfo(data, cb) {
    req.post(portal + `/device/appraiseInfo/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改
  updateInfo(data, cb) {
    req.put(portal + `/device/appraiseInfo/`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getInfoById(id, cb) {
    req.get(portal + `/device/appraiseInfo/` + id).then(res => {
      cb(res.data)
    })
  },
  // /* 考核项 */
  //分页查询
  loadAppraiseItems(data, cb) {
    req.post(portal + `/device/appraiseBase/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 新增
  addItems(data, cb) {
    req.post(portal + `/device/appraiseBase/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改
  updateItems(data, cb) {
    req.put(portal + `/device/appraiseBase/`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id修改发布状态
  updatePublish(data, cb) {
    req.post(portal + `/device/appraiseBase/status` ,data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/device/appraiseBase/` + id).then(res => {
      cb(res.data)
    })
  },
  // /* 考核标准 */
  // 批量删除
  remove(ids, cb) {
    req.remove(portal + `/device/appraiseBase/?ids=` + ids).then(res => {
      cb(res.data)
    })
  },
  // 获取被考核者
  getExaminees(data, cb){
    req.post(portal + `/device/appraiseInfo/getExaminees`, data).then(res => {
      cb(res.data)
    })
  }
  
}
