import req from '@/request.js'

const portal = window.context.portal
const headers = {
  'Content-type': 'application/x-www-form-urlencoded'
}
export default {
  // 根据id查询设备信息
  deviceDetails(id, cb) {
    req.get(portal + '/device/info/' + id).then((res) => {
      cb(res.data)
    })
  },
  // 根据id查询设备信息
  deviceDetailsInfo(id, cb) {
    req.get(portal + '/device/info/detail/' + id).then((res) => {
      cb(res.data)
    })
  },
  // 获取设备扩展参数配置
  getExtendParams(data, cb) {
    req.post(portal + '/device/params/conf/findAll', data).then((rep) => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  // 根据id启禁用设备
  deviceflag(data, cb) {
    req.post(portal + '/device/info/modifyEnabled', data).then((res) => {
      cb(res.data)
    })
  },
  // 根据产品id获取设备数量
  getDeviceInfo(data, cb) {
    console.log(data, '9999999')
    let datas = ''
    if (data.productId !== '') {
      datas = data.productId
    }
    // req
    //   .request({
    //     method: 'post',
    //     url: portal + '/device/info/getDeviceInfo',
    //     data,
    //     headers
    //   })
    //   .then(res => {
    //     cb(res.data)
    //   })
    req.post(portal + `/device/info/getDeviceInfo?productIds=${datas}`).then((res) => {
      cb(res.data)
    })
  },
  // 分页查询区域
  loadArea(data, cb) {
    req.post(portal + `/device/baseArea/query`, data).then((res) => {
      cb(res.data)
    })
  },
  // 获取产品扩展参数配置
  getProductParams(data, cb) {
    req
      .post(portal + '/device/product/paramsConf/findAll', data)
      .then((rep) => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 分页查询设备所属合同
  getDeviceList(data, cb) {
    req
      .post(portal + '/device/relation/contract/findByContractPage', data)
      .then((rep) => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  //附件下载
  accessoryDownload(data) {
    req.downloadGetCopy(portal + '/file/v1/downloadFile=' + data)
  },
  // 删除关联信息
  delete(ids, cb) {
    req
      .remove(portal + '/biz/task/schedulerTask/v1/?ids=' + ids)
      .then((rep) => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 获取合同关联信息
  getContractList(data, cb) {
    req
      .post(portal + '/device/relation/contract/getContractList', data)
      .then((rep) => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 新增设备关联合同
  saveDevice(data, cb) {
    req
      .post(portal + '/device/relation/contract/bindContract', data)
      .then((rep) => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  //告警查询
  load(data, cb) {
    req.post(portal + `/device/product/warnConf/query`, data).then((res) => {
      cb(res.data)
    })
  },
  // 物模型事件查询
  loadEventDefinition(data, cb) {
    req.post(portal + `/device/metadata/events/query`, data).then((res) => {
      cb(res.data)
    })
  },
  // 物模型属性列表
  attributeList(data, cb) {
    req.post(portal + '/device/metadata/properties/query', data).then((rep) => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  //告警新增
  addAlerts(data, cb) {
    req.post(portal + `/device/warn/conf/`, data).then((res) => {
      cb(res.data)
    })
  },
  //告警查询
  loadAlerts(data, cb) {
    req.post(portal + `/device/warn/conf/query`, data).then((res) => {
      cb(res.data)
    })
  },
  //告警根据id查询
  findAlerts(id, cb) {
    req.get(portal + '/device/warn/conf/' + id).then((res) => {
      cb(res.data)
    })
  },
  //产品告警根据id查询
  findProductAlerts(id, cb) {
    req.get(portal + '/device/product/warnConf/' + id).then((res) => {
      cb(res.data)
    })
  },
  //告警修改
  modifyAlerts(data, cb) {
    req.put(portal + '/device/warn/conf/', data).then((rep) => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  modifyEnabled(data, cb) {
    req.post(portal + `/device/warn/conf/modifyEnabled`, data).then((res) => {
      cb(res.data)
    })
  },
  // 新增状态日志
  addLog(data, cb) {
    req.post(portal + `/deviceStatusLog/v1/`, data).then((rep) => {
      cb(rep.data)
    })
  },
  // 修改状态日志
  updateLog(data, cb) {
    req.put(portal + `/deviceStatusLog/v1/`, data).then((rep) => {
      cb(rep.data)
    })
  },
  // 分页查询状态日志
  loadLog(data, cb) {
    req.post(portal + `/deviceStatusLog/v1/query`, data).then((rep) => {
      cb(rep.data)
    })
  },
  // 修改设备状态信息
  updateStatus(data, cb) {
    req
      .post(
        portal +
        `/device/info/updateStatus?id=${data.id}&&productCode=${data.productCode}&&status=${data.status}`
      )
      .then((rep) => {
        cb(rep.data)
      })
  },
  //视频点位数据导出
  exportPointBase(data, cb) {
    req
      .post(portal + `/biz/catalog/base/exportPoint`, data, 'blob')
      .then((res) => {
        cb(res.data)
      })
  },
  // 修改设备状态信息
  updateImportant(data, cb) {
    req
      .post(
        portal +
        `/device/info/updateImportant?id=${data.id}&&important=${data.important}`
      )
      .then((rep) => {
        cb(rep.data)
      })
  },
  // 修改设备状态信息
  updateImportantPoint(data, cb) {
    req
      .post(
        portal +
        `/biz/catalog/base/point/updateImportant?id=${data.id}&&important=${data.important}`
      )
      .then((rep) => {
        cb(rep.data)
      })
  },
  //   // 物模型属性列表
  // updateImportantPoint(data, cb) {
  //   req.post(portal + '/biz/catalog/base/point/updateImportant', data).then(rep => {
  //     if (rep.data) {
  //       cb(rep.data)
  //     }
  //   })
  // },
  // 根据id查询状态日志信息
  findLogById(id, cb) {
    req.get(portal + '/deviceStatusLog/v1/' + id).then((res) => {
      cb(res.data)
    })
  },
  // // 根据设备id获取实时数据
  // realData(id, cb) {
  //   req.post(portal + '/device/data/query?id=' + id).then(res => {
  //     cb(res.data)
  //   })s
  // }
  supplierId(id, cb) {
    req.get(portal + '/device/base/company/' + id).then((res) => {
      cb(res.data)
    })
  },
  managerId(id, cb) {
    req.get(portal + '/device/base/user/' + id).then((res) => {
      cb(res.data)
    })
  },
  // 查询区域下拉树
  loadAreaTree(data, cb) {
    req.post(portal + `/device/baseArea/getTree`, data).then((res) => {
      cb(res.data)
    })
  },

  // 设备管理 => 设备管理 点位修改
  pointUpdate(data, cb) {
    req.post(portal + `/device/info/update/point`, data).then((res) => {
      cb(res.data)
    })
  }
}
