import req from '@/request.js'
const portal = window.context.portal
export default {
	// 获取备件库列表
	findSWList (data, cb) {
		req.post(portal + '/device/base/warehouse/query', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 根据id查询
	findSWDetails (id, cb) {
		req.get(portal + '/device/base/warehouse/' + id).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 添加备件库信息
	addSpareWarehouse (data, cb) {
		req.post(portal + '/device/base/warehouse/', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 修改备件库信息
	modifySpareWarehouse (data, cb) {
		req.put(portal + '/device/base/warehouse/', data).then(rep => {
			if (rep.data) {
				cb(rep.data)
			}
		})
	},
	// 删除单个备件库信息
	removeSpareWarehouse (ids) {
		return new Promise((resolve, reject) => {
			req.remove(portal + '/device/base/warehouse/' + ids).then(res => {
				resolve(res);
			}, error => {
				reject(error);
			})
		})
	},
}
