import req from '@/request.js'
const portal = window.context.portal
export default {
    /**
     * 
     * @param {传参} data 
     * @param {回调} cb 
     */
    // 物模型属性列表
    attributeList(data, cb) {
        req.post(portal + '/device/metadata/properties/query', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    // 物模型属性添加
    attributeAdd(data, cb) {
        req.post(portal + '/device/metadata/properties/', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    // 物模型属性更新
    modifyAttribute(data, cb) {
        req.put(portal + '/device/metadata/properties/', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    //物模型属性排序
    saveAttributeProperty(data, cb) {
        req.post(portal + `/device/metadata/properties/updateSequence`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 物模型功能分页
    FunctionList(data, cb) {
        req.post(portal + '/device/metadata/functions/query', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    // 物模型功能添加
    AddFunction(data, cb) {
        req.post(portal + '/device/metadata/functions/', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    // 物模型功能更新
    modifyFunction(data, cb) {
        req.put(portal + '/device/metadata/functions/', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    //物模型功能根据ID查询
    FunctionDetails(id, cb) {
        req.get(portal + '/device/metadata/functions/' + id).then(res => {
            cb(res.data)
        })
    },
    //物模型功能排序
    saveFunctionProperty(data, cb) {
        req.post(portal + `/device/metadata/functions/updateSequence`, data).then(rep => {
            cb(rep.data);
        });
    },
    // 物模型事件查询
    loadEventDefinition(data, cb) {
        req.post(portal + `/device/metadata/events/query`, data).then(res => {
            cb(res.data)
        })
    },
    //物模型事件添加
    addEventDefinition(data, cb) {
        req.post(portal + `/device/metadata/events/`, data).then(res => {
            cb(res.data)
        })
    },
    //物模型事件根据id查询
    findEventDefinition(id, cb) {
        req.get(portal + '/device/metadata/events/' + id).then(res => {
            cb(res.data)
        })
    },
    //物模型事件修改
    modifyEventDefinition(data, cb) {
        req.put(portal + '/device/metadata/events/', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    // 物模型事件删除
    removeEventDefinition(data, cb) {
        req.remove(portal + `/device/metadata/events/`, data).then(res => {
            cb(res.data)
        })
    },
    //物模型事件排序
    saveProperty(data, cb) {
        req.post(portal + `/device/metadata/events/updateSequence`, data).then(rep => {
            cb(rep.data);
        });
    },
    //告警新增
    addAlerts(data, cb) {
        req.post(portal + `/device/product/warnConf/`, data).then(res => {
            cb(res.data)
        })
    },
    //告警查询
    loadAlerts(data, cb) {
        req.post(portal + `/device/product/warnConf/query`, data).then(res => {
            cb(res.data)
        })
    },
    //告警根据id查询
    findAlerts(id, cb) {
        req.get(portal + '/device/product/warnConf/' + id).then(res => {
            cb(res.data)
        })
    },
    //告警修改
    modifyAlerts(data, cb) {
        req.put(portal + '/device/product/warnConf/', data).then(rep => {
            if (rep.data) {
                cb(rep.data)
            }
        })
    },
    //告警排序
    savePropertyAlerts(data, cb) {
        req.post(portal + `/device/product/warnConf/updateSequence`, data).then(rep => {
            cb(rep.data);
        });
    },
}	
