import req from '@/request.js'
const portal = window.context.portal
export default {
  // 分页查询
  queryData(data, cb) {
    req.post(portal + `/deviceInspectionResult/v1/phoneMaintenance`, data).then(res => {
      cb(res.data)
    })
  },
  //通过id获取详情
  detailData(data, cb) {
    req.get(portal + `/deviceInspectionResult/v1/details?id=` + data).then(res => {
      cb(res.data)
    })
  },
  // 获取所属部门
  byParentAndDemToTree(data, cb) {
    req.get(portal + `/manager/cmgtDutyOrgWorkarrange/findAllOrg`).then(res => {
      cb(res.data)
    })
  },
  //提交
  addDetail(data, cb) {
    req.post(portal + `/deviceInspectionResult/v1/edit`, data).then(res => {
      cb(res.data)
    })
  },
  //报修
  repair(data, cb) {
    req.post(portal + `/deviceInspectionResult/v1/phonePushData`, data).then(res => {
      cb(res.data)
    })
  },
  //工单查询
  workOrderQuery(data, cb) {
    req.post(portal + `/deviceInspectionMaintenance/v1/listByPage?isAffirm=false`, data).then(res => {
      cb(res.data)
    })
  },
  //工单详情
  workOrderDetail(data, cb) {
    req.get(portal + `/deviceInspectionMaintenance/v1/details?id=` + data).then(res => {
      cb(res.data)
    })
  },
  //更新工单
  workOrderPut(data, cb) {
    req.post(portal + `/deviceInspectionMaintenance/v1/edit`, data).then(req => {
      cb(req.data)
    })
  },
  //获取巡查计划
  inspectionPlan(data, cb) {
    req.post(portal + `/deviceInspectionResult/v1/listByPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 巡查任务查询
  inspectionTask(data, cb) {
    req.post(portal + `/deviceInspectionTask/v1/queryPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 任务详情设备列表查询
  getTaskDetailsById(data, cb) {
    req.post(portal + `/deviceInspectionTaskDetails/v1/queryPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 接收任务
  receivingTask({ id, status }, cb) {
    req.post(portal + `/deviceInspectionTask/v1/updateById?id=${id}&status=${status}`).then(res => {
      cb(res.data)
    })
  },
  // 根据设备id查询结果详情
  getResultDetails(id, cb) {
    req.get(portal + `/deviceInspectionResult/v1/${id}`).then(res => {
      cb(res.data)
    })
  },
  // 图片上传
  uploadImg(data, formData, cb) {
    const { bizCode, bizId } = data
    req.post(portal + `/file/v1/uploadFileForConfig?bizCode=${bizCode}&bizId=${bizId}`, formData).then(res => {
      cb(res.data)
    })
  },
  // 图片删除
  deleteImg(id, cb) {
    req.remove(portal + `/file/v1/${id}`).then(res => {
      cb(res.data)
    })
  },
  // 巡查结果录入
  resultEnter(data, cb) {
    req.post(portal + `/deviceInspectionResult/v1/saveOrUpdateInfo`, data).then(res => {
      cb(res.data)
    })
  },
  // 事件上报
  eventReporting(id, cb) {
    req.post(portal + `/deviceInspectionResult/v1/eventBack?resultId=${id}`).then(res => {
      cb(res.data)
    })
  },
  // 事件处置详情
  // 查询事件处理结果详细
  getEventDetails(id) {
    req.get(`http://10.23.193.248:9001/event-back/openApi/api/common/getEventInfo?warningId=${id}`).then(res => {
      cb(res.data)
    })
  }
}
