import req from '@/request.js'
const portal = window.context.portal
export default {
    // 群组列表
    infoQuery(data, cb) {
        req.post(portal + `/api/userGroup/v1/userGroups/getUserGroupPage`, data).then(res => {
            cb(res.data)
        })
    },
    // 新增群组
    addGroup(data, cb) {
        req.post(portal + `/api/userGroup/v1/userGroup/addUserGroup`, data).then(res => {
            cb(res.data)
        })
    },
    // 根据id查询实体
    getGroupById(id, cb) {
        req.get(portal + `/api/userGroup/v1/` + id).then(res => {
            cb(res.data)
        })
    },
    // 获取指定群组下人员信息
    getGroupByCode(code, cb) {
        req.get(portal + `/api/userGroup/v1/userGroup/getGroupUsers?code=` + code).then(res => {
            cb(res.data)
        })
    },
    // 更新群组
    editGroup(data, cb) {
        req.put(portal + `/api/userGroup/v1/userGroup/updateUserGroup`, data).then(res => {
            cb(res.data)
        })
    },
    // 群组添加用户组
    addGroupUser(code,data, cb) {
        req.post(portal + `/api/userGroup/v1/userGroup/addGroupUsers?code=` + code, data).then(res => {
            cb(res.data)
        })
    },
}
