import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 获取巡检台账表格数据
export function listData(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/user/v1/users/getOrgUserQuery`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取用户详情信息
export function userDetails(account) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/api/user/v1/user/getDetailByAccountOrId?account=${account}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取角色列表
export function getRolePage() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/role/v1/roles/getRolePage`, {
      pageBean: {pageSize: -1}
    })
      .then(res => resolve(res?.data?.rows || []))
      .catch(err => reject(err))
  })
}

// 修改个人信息
export function updateUser(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/user/v1/user/updateUser`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 根据用户新增角色
export function addUserRole(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/role/v1/roleUser/addUserRole?${qs.stringify(data)}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}









