import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 案件类型排名统计
export function queryCaseTypeSortStatistics(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/queryCaseTypeSortStatistics?${qs.stringify(query)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 案件来源排名统计
export function queryCaseSourceSortStatistics(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/queryCaseSourceSortStatistics?${qs.stringify(query)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 类型同比分析
export function queryTimeOrCaseTypeCStatistics(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/queryTimeOrCaseTypeCStatistics?${qs.stringify(query)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 区域高发排名
export function queryAreaSortStatistics(query = {}) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/queryAreaSortStatistics?${qs.stringify(query)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}











