import req from '@/request.js'

const portal = window.context.portal
export default {
  // 新增队员信息
  addMember(data, cb) {
    req.post(portal + `/manager/duty/member/create`, data).then(res => {
      cb(res.data)
    })
  },

  // 修改队员信息
  editMember(data, cb) {
    req.put(portal + `/manager/duty/member/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询队员信息
  loadMember(data, cb) {
    req.post(portal + `/manager/duty/member/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询队员信息
  pageQuery(data) {
    return req.post(portal + `/manager/duty/member/pageQuery`, data)
  },
  // 批量删除队员信息
  deleteMember(data, cb) {
    req.remove(portal + `/manager/duty/member/`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取小组信息
  findTeam(cb) {
    req.post(portal + `/manager/duty/member/query/team`).then(res => {
      cb(res.data)
    })
  },
  // 获取执法仪信息
  getDeviceInfo(data, cb) {
    req.post(portal + `/device/info/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取执法仪是否绑定人员
  determineDeviceStatus(data, cb){
    req.get(portal + `/manager/duty/member/queryDeviceInfo?` + data,).then(res => {
      cb(res.data)
    })
  },
  // 根据id解绑执法仪
  unbindingDevice(id, cb){
    req.get(portal + `/manager/duty/member/updateDeviceCodeId?memberId=${id}`).then(res => {
      cb(res.data)
    })
  },
  // 导出队员
  exportMember(data,cb){
    req.post(portal + `/manager/duty/member/export`, data, 'blob').then(res => {
      cb(res.data)
    })
  }
}
