import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 获取巡检设备入口列表（巡检计划）
export function inspectionPlanTable(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/listByPage`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 根据巡检计划ID获取设备列表
export function equipmentTable(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/inspectionById`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取设备产品分类列表
export function getProductTree(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/device/product/type/getProductTree`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 报事报修
export function faultWorkOrder(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/pushData?id=${id}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// (不分页)部门树
export function getByParentAndDemToTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/manager/cmgtDutyOrgWorkarrange/findAllOrgTree`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取设备详情
export function deviceDetails(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionResult/v1/details?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 登记巡查设备信息
export function registerEquipment(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/inspectionEdit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}











