import req from '@/request'

const portal = window.context.portal

// 获取设备巡检巡查设备表格数据
export function tableData(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/listByPage?isAffirm=true`, data)
      .then(res => resolve(res.data))
      .catch(err => reject(err))
  })
}

// 获取设备巡检巡查设备详情
export function resultDetails(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionResult/v1/details?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 部门树(不分页)
export function getByParentAndDemToTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/api/org/v1/orgs/getByParentAndDemToTree`, {
      demId: '1491618454686535680'
    })
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改设备巡检巡查设备信息
export function resultEdit(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/edit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除设备巡检巡查设备信息
export function resultRemove(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/deviceInspectionResult/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 生成故障工单
export function faultWorkOrder(id) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionResult/v1/pushData?id=${id}`, 'json', 0)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}









